/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.SchemaInfo;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;

public class SearchDataTypeValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        List<SearchCluster> clusters = model.getSearchClusters();
        for (SearchCluster cluster : clusters) {
            if (cluster.isStreaming()) continue;
            for (SchemaInfo spec : cluster.schemas().values()) {
                SDDocumentType docType = spec.fullSchema().getDocument();
                if (docType == null) continue;
                this.validateDocument(cluster, spec.fullSchema(), docType);
            }
        }
    }

    private void validateDocument(SearchCluster cluster, Schema schema, SDDocumentType doc) {
        for (SDDocumentType child : doc.getTypes()) {
            this.validateDocument(cluster, schema, child);
        }
        for (Field field : doc.fieldSet()) {
            DataType fieldType = field.getDataType();
            this.disallowIndexingOfMaps(cluster, schema, field);
            if (this.isSupportedInSearchClusters(fieldType)) continue;
            throw new IllegalArgumentException("Field type '" + fieldType.getName() + "' is illegal for search clusters (field '" + field.getName() + "' in schema '" + schema.getName() + "' for cluster '" + cluster.getClusterName() + "').");
        }
    }

    private boolean isSupportedInSearchClusters(DataType dataType) {
        if (dataType instanceof ArrayDataType || dataType instanceof WeightedSetDataType) {
            return this.isSupportedInSearchClusters(((CollectionDataType)dataType).getNestedType());
        }
        if (dataType instanceof StructDataType) {
            return true;
        }
        if (dataType instanceof MapDataType) {
            return true;
        }
        if (dataType instanceof TensorDataType) {
            return true;
        }
        if (dataType instanceof NewDocumentReferenceDataType) {
            return true;
        }
        return dataType.equals((Object)DataType.INT) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.STRING) || dataType.equals((Object)DataType.RAW) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.URI) || dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.BOOL) || dataType.equals((Object)DataType.PREDICATE);
    }

    private void disallowIndexingOfMaps(SearchCluster cluster, Schema schema, Field field) {
        DataType fieldType = field.getDataType();
        if (fieldType instanceof MapDataType && ((SDField)field).doesIndexing()) {
            throw new IllegalArgumentException("Field type '" + fieldType.getName() + "' cannot be indexed for search clusters (field '" + field.getName() + "' in definition '" + schema.getName() + "' for cluster '" + cluster.getClusterName() + "').");
        }
    }
}

