/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.cloud.config.log.LogdConfig;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.ConfigProxy;
import com.yahoo.vespa.model.ConfigSentinel;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.Logd;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.LogForwarder;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.LogserverContainerCluster;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.admin.ZooKeepersConfigProvider;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainer;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainerCluster;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Admin
extends AbstractConfigProducer<Admin>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isHostedVespa;
    private final Monitoring monitoring;
    private final List<Configserver> configservers = new ArrayList<Configserver>();
    private final Metrics metrics;
    private MetricsProxyContainerCluster metricsProxyCluster;
    private MetricSet additionalDefaultMetrics = MetricSet.empty();
    private final List<Slobrok> slobroks = new ArrayList<Slobrok>();
    private Configserver defaultConfigserver;
    private Logserver logserver;
    private LogForwarder.Config logForwarderConfig = null;
    private boolean logForwarderIncludeAdmin = false;
    private final ConfigModelContext.ApplicationType applicationType;
    private ClusterControllerContainerCluster clusterControllers;
    private Optional<LogserverContainerCluster> logServerContainerCluster = Optional.empty();
    private ZooKeepersConfigProvider zooKeepersConfigProvider;
    private final FileDistributionConfigProducer fileDistribution;
    private final boolean multitenant;

    public void setLogForwarderConfig(LogForwarder.Config cfg, boolean includeAdmin) {
        this.logForwarderConfig = cfg;
        this.logForwarderIncludeAdmin = includeAdmin;
    }

    public Admin(AbstractConfigProducer<?> parent, Monitoring monitoring, Metrics metrics, boolean multitenant, boolean isHostedVespa, ConfigModelContext.ApplicationType applicationType) {
        super(parent, "admin");
        this.isHostedVespa = isHostedVespa;
        this.monitoring = monitoring;
        this.metrics = metrics;
        this.multitenant = multitenant;
        this.fileDistribution = new FileDistributionConfigProducer(parent);
        this.applicationType = applicationType;
    }

    public Configserver getConfigserver() {
        return this.defaultConfigserver;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public Metrics getUserMetrics() {
        return this.metrics;
    }

    public MetricsProxyContainerCluster getMetricsProxyCluster() {
        return this.metricsProxyCluster;
    }

    public void setAdditionalDefaultMetrics(MetricSet additionalDefaultMetrics) {
        if (additionalDefaultMetrics == null) {
            return;
        }
        this.additionalDefaultMetrics = additionalDefaultMetrics;
    }

    public MetricSet getAdditionalDefaultMetrics() {
        return this.additionalDefaultMetrics;
    }

    public List<Configserver> getConfigservers() {
        return this.configservers;
    }

    public List<Slobrok> getSlobroks() {
        return Collections.unmodifiableList(this.slobroks);
    }

    public void setLogserver(Logserver logserver) {
        this.logserver = logserver;
    }

    public Logserver getLogserver() {
        return this.logserver;
    }

    public void addConfigservers(List<Configserver> configservers) {
        this.configservers.addAll(configservers);
        if (this.configservers.size() > 0) {
            this.defaultConfigserver = configservers.get(0);
        }
        this.zooKeepersConfigProvider = new ZooKeepersConfigProvider(configservers);
    }

    public void addSlobroks(List<Slobrok> slobroks) {
        this.slobroks.addAll(slobroks);
    }

    public ClusterControllerContainerCluster getClusterControllers() {
        return this.clusterControllers;
    }

    public void setClusterControllers(ClusterControllerContainerCluster clusterControllers, DeployState deployState) {
        this.clusterControllers = clusterControllers;
        if (this.isHostedVespa) {
            this.removeSlobroks();
            this.addSlobroks(this.createSlobroksOn(clusterControllers, deployState));
        }
    }

    private void removeSlobroks() {
        this.slobroks.forEach(AbstractService::remove);
        this.slobroks.clear();
    }

    private List<Slobrok> createSlobroksOn(ClusterControllerContainerCluster clusterControllers, DeployState deployState) {
        ArrayList<Slobrok> slobroks = new ArrayList<Slobrok>();
        for (ClusterControllerContainer clusterController : clusterControllers.getContainers()) {
            Slobrok slobrok = new Slobrok(this, clusterController.index(), deployState.featureFlags());
            slobrok.setHostResource(clusterController.getHostResource());
            slobroks.add(slobrok);
            slobrok.initService(deployState);
        }
        return slobroks;
    }

    public Optional<LogserverContainerCluster> getLogServerContainerCluster() {
        return this.logServerContainerCluster;
    }

    public void setLogserverContainerCluster(LogserverContainerCluster logServerContainerCluster) {
        this.logServerContainerCluster = Optional.of(logServerContainerCluster);
    }

    public ZooKeepersConfigProvider getZooKeepersConfigProvider() {
        return this.zooKeepersConfigProvider;
    }

    public void getConfig(LogdConfig.Builder builder) {
        if (this.logserver == null) {
            builder.logserver(new LogdConfig.Logserver.Builder().use(false));
        } else {
            builder.logserver(new LogdConfig.Logserver.Builder().userpc(true).use(this.logServerContainerCluster.isPresent() || !this.isHostedVespa).host(this.logserver.getHostName()).rpcport(this.logserver.getRelativePort(0)));
        }
    }

    public void getConfig(SlobroksConfig.Builder builder) {
        for (Slobrok slob : this.slobroks) {
            builder.slobrok(new SlobroksConfig.Slobrok.Builder().connectionspec(slob.getConnectionSpec()));
        }
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        this.zooKeepersConfigProvider.getConfig(builder);
    }

    public FileDistributionConfigProducer getFileDistributionConfigProducer() {
        return this.fileDistribution;
    }

    public void addPerHostServices(List<HostResource> hosts, DeployState deployState) {
        if (this.slobroks.isEmpty()) {
            this.slobroks.addAll(this.createDefaultSlobrokSetup(deployState));
        }
        if (!deployState.isHosted() || !deployState.getProperties().applicationId().instance().isTester()) {
            this.addMetricsProxyCluster(hosts, deployState);
        }
        for (HostResource host : hosts) {
            if (host.getHost().runsConfigServer()) continue;
            this.addCommonServices(host, deployState);
        }
    }

    private void addMetricsProxyCluster(List<HostResource> hosts, DeployState deployState) {
        this.metricsProxyCluster = new MetricsProxyContainerCluster(this, "metrics", deployState);
        int index = 0;
        for (HostResource host : hosts) {
            MetricsProxyContainer container = new MetricsProxyContainer(this.metricsProxyCluster, host, index, deployState);
            this.addAndInitializeService(deployState, host, container);
            this.metricsProxyCluster.addContainer(container);
        }
    }

    private void addCommonServices(HostResource host, DeployState deployState) {
        this.addConfigSentinel(deployState, host, deployState.getProperties().applicationId(), deployState.zone(), deployState.featureFlags());
        this.addLogd(deployState, host);
        this.addConfigProxy(deployState, host);
        this.addFileDistribution(host);
        if (this.logForwarderConfig != null) {
            ClusterSpec.Type clustertype;
            boolean actuallyAdd = true;
            Optional membership = host.spec().membership();
            if (membership.isPresent() && (clustertype = ((ClusterMembership)membership.get()).cluster().type()) == ClusterSpec.Type.admin) {
                actuallyAdd = this.logForwarderIncludeAdmin;
            }
            if (actuallyAdd) {
                this.addLogForwarder(deployState, host);
            }
        }
    }

    private void addConfigSentinel(DeployState deployState, HostResource host, ApplicationId applicationId, Zone zone, ModelContext.FeatureFlags featureFlags) {
        ConfigSentinel configSentinel = new ConfigSentinel(host.getHost(), applicationId, zone, featureFlags);
        this.addAndInitializeService(deployState, host, configSentinel);
        host.getHost().setConfigSentinel(configSentinel);
    }

    private void addLogForwarder(DeployState deployState, HostResource host) {
        this.addAndInitializeService(deployState, host, new LogForwarder((AbstractConfigProducer)host.getHost(), this.logForwarderConfig));
    }

    private void addLogd(DeployState deployState, HostResource host) {
        this.addAndInitializeService(deployState, host, new Logd(host.getHost()));
    }

    private void addConfigProxy(DeployState deployState, HostResource host) {
        this.addAndInitializeService(deployState, host, new ConfigProxy(host.getHost()));
    }

    public void addAndInitializeService(DeployState deployState, HostResource host, AbstractService service) {
        service.setHostResource(host);
        service.initService(deployState);
    }

    private void addFileDistribution(HostResource host) {
        FileDistributionConfigProvider configProvider = new FileDistributionConfigProvider(this.fileDistribution, host.getHost());
        this.fileDistribution.addFileDistributionConfigProducer(host.getHost(), configProvider);
    }

    private List<Slobrok> createDefaultSlobrokSetup(DeployState deployState) {
        List<HostResource> hosts = this.hostSystem().getHosts();
        ArrayList<Slobrok> slobs = new ArrayList<Slobrok>();
        if (this.logserver != null) {
            Slobrok slobrok = new Slobrok(this, 0, deployState.featureFlags());
            this.addAndInitializeService(deployState, this.logserver.getHostResource(), slobrok);
            slobs.add(slobrok);
        }
        for (int n = 0; n < hosts.size() && slobs.size() < 3; ++n) {
            HostResource host = hosts.get(n);
            if (this.logserver != null && host == this.logserver.getHostResource() || host.getHost().runsConfigServer()) continue;
            Slobrok newSlobrok = new Slobrok(this, slobs.size(), deployState.featureFlags());
            this.addAndInitializeService(deployState, host, newSlobrok);
            slobs.add(newSlobrok);
        }
        int j = 0;
        for (Slobrok s : slobs) {
            s.setProp("index", j);
            ++j;
        }
        return slobs;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public ConfigModelContext.ApplicationType getApplicationType() {
        return this.applicationType;
    }
}

