/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.vespa.documentmodel.FieldView;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class DocumentSummary
extends FieldView {
    private int id;
    private boolean fromDisk = false;
    private boolean omitSummaryFeatures = false;
    private Optional<String> inherited = Optional.empty();
    private final Schema owner;

    public DocumentSummary(String name, Schema owner) {
        super(name);
        this.owner = owner;
    }

    public int id() {
        return this.id;
    }

    public void setFromDisk(boolean fromDisk) {
        this.fromDisk = fromDisk;
    }

    public boolean isFromDisk() {
        return this.fromDisk;
    }

    public void setOmitSummaryFeatures(boolean value) {
        this.omitSummaryFeatures = value;
    }

    public boolean omitSummaryFeatures() {
        return this.omitSummaryFeatures;
    }

    public void add(SummaryField summaryField) {
        summaryField.addDestination(this.getName());
        super.add(summaryField);
    }

    public SummaryField getSummaryField(String name) {
        SummaryField field = (SummaryField)this.get(name);
        if (field != null) {
            return field;
        }
        if (this.inherited().isEmpty()) {
            return null;
        }
        return this.inherited().get().getSummaryField(name);
    }

    public Map<String, SummaryField> getSummaryFields() {
        LinkedHashMap<String, SummaryField> fields = new LinkedHashMap<String, SummaryField>(this.getFields().size());
        this.inherited().ifPresent(inherited -> fields.putAll(inherited.getSummaryFields()));
        for (Field field : this.getFields()) {
            fields.put(field.getName(), (SummaryField)field);
        }
        return fields;
    }

    public void purgeImplicits() {
        ArrayList<SummaryField> falseImplicits = new ArrayList<SummaryField>();
        for (SummaryField summaryField : this.getSummaryFields().values()) {
            if (summaryField.isImplicit()) continue;
            Iterator<SummaryField.Source> j = summaryField.sourceIterator();
            while (j.hasNext()) {
                SummaryField sourceField;
                String sourceName = j.next().getName();
                if (sourceName.equals(summaryField.getName()) || (sourceField = this.getSummaryField(sourceName)) == null || !sourceField.isImplicit()) continue;
                falseImplicits.add(sourceField);
            }
        }
        for (SummaryField field : falseImplicits) {
            this.remove(field.getName());
        }
    }

    public void setInherited(String inherited) {
        this.inherited = Optional.of(inherited);
    }

    public Optional<DocumentSummary> inherited() {
        return this.inherited.map(name -> this.owner.getSummary((String)name));
    }

    public String toString() {
        return "document summary '" + this.getName() + "'";
    }

    public void validate(DeployLogger logger) {
        if (this.inherited.isPresent() && !this.owner.getSummaries().containsKey(this.inherited.get())) {
            logger.log(Level.WARNING, this + " inherits " + this.inherited.get() + " but this is not present in " + this.owner);
            logger.logApplicationPackage(Level.WARNING, this + " inherits " + this.inherited.get() + " but this is not present in " + this.owner);
        }
    }
}

