/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedBlock;
import com.yahoo.searchdefinition.parser.ParsedSorting;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ParsedAttribute
extends ParsedBlock {
    private boolean enableBitVectors = false;
    private boolean enableOnlyBitVector = false;
    private boolean enableFastAccess = false;
    private boolean enableFastRank = false;
    private boolean enableFastSearch = false;
    private boolean enableHuge = false;
    private boolean enableMutable = false;
    private boolean enablePaged = false;
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private ParsedSorting sortSettings = null;
    private String distanceMetric = null;

    ParsedAttribute(String name) {
        super(name, "attribute");
    }

    List<String> getAliases() {
        return List.copyOf(this.aliases.keySet());
    }

    String lookupAliasedFrom(String alias) {
        return this.aliases.get(alias);
    }

    Optional<String> getDistanceMetric() {
        return Optional.ofNullable(this.distanceMetric);
    }

    boolean getEnableBitVectors() {
        return this.enableBitVectors;
    }

    boolean getEnableOnlyBitVector() {
        return this.enableOnlyBitVector;
    }

    boolean getFastAccess() {
        return this.enableFastAccess;
    }

    boolean getFastRank() {
        return this.enableFastRank;
    }

    boolean getFastSearch() {
        return this.enableFastSearch;
    }

    boolean getHuge() {
        return this.enableHuge;
    }

    boolean getMutable() {
        return this.enableMutable;
    }

    boolean getPaged() {
        return this.enablePaged;
    }

    Optional<ParsedSorting> getSorting() {
        return Optional.ofNullable(this.sortSettings);
    }

    void addAlias(String from, String to) {
        this.verifyThat(!this.aliases.containsKey(to), "already has alias", to);
        this.aliases.put(to, from);
    }

    void setDistanceMetric(String value) {
        this.verifyThat(this.distanceMetric == null, "already has distance-metric", this.distanceMetric);
        this.distanceMetric = value;
    }

    ParsedSorting sortInfo() {
        if (this.sortSettings == null) {
            this.sortSettings = new ParsedSorting(this.name(), "attribute.sorting");
        }
        return this.sortSettings;
    }

    void setEnableBitVectors(boolean value) {
        this.enableBitVectors = value;
    }

    void setEnableOnlyBitVector(boolean value) {
        this.enableOnlyBitVector = value;
    }

    void setFastAccess(boolean value) {
        this.enableFastAccess = true;
    }

    void setFastRank(boolean value) {
        this.enableFastRank = true;
    }

    void setFastSearch(boolean value) {
        this.enableFastSearch = true;
    }

    void setHuge(boolean value) {
        this.enableHuge = true;
    }

    void setMutable(boolean value) {
        this.enableMutable = true;
    }

    void setPaged(boolean value) {
        this.enablePaged = true;
    }
}

