/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.parser.ParsedDocument;
import com.yahoo.searchdefinition.parser.ParsedSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InheritanceResolver {
    private final Map<String, ParsedSchema> parsedSchemas;
    private final Map<String, ParsedDocument> parsedDocs = new HashMap<String, ParsedDocument>();
    private final Map<String, ParsedSchema> schemaForDocs = new HashMap<String, ParsedSchema>();

    public InheritanceResolver(Map<String, ParsedSchema> parsedSchemas) {
        this.parsedSchemas = parsedSchemas;
    }

    private void inheritanceCycleCheck(ParsedSchema schema, List<String> seen) {
        String name = schema.name();
        if (seen.contains(name)) {
            seen.add(name);
            throw new IllegalArgumentException("Inheritance/reference cycle for schemas: " + String.join((CharSequence)" -> ", seen));
        }
        seen.add(name);
        for (ParsedSchema parent : schema.getAllResolvedInherits()) {
            this.inheritanceCycleCheck(parent, seen);
        }
        seen.remove(name);
    }

    private void resolveSchemaInheritance() {
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            for (String inherit : schema.getInherited()) {
                ParsedSchema parent = this.parsedSchemas.get(inherit);
                if (parent == null) {
                    throw new IllegalArgumentException("schema '" + schema.name() + "' inherits '" + inherit + "', but this schema does not exist");
                }
                schema.resolveInherit(inherit, parent);
            }
        }
    }

    private void checkSchemaCycles() {
        ArrayList<String> seen = new ArrayList<String>();
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            this.inheritanceCycleCheck(schema, seen);
        }
    }

    private void resolveDocumentInheritance() {
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            if (!schema.hasDocument()) {
                throw new IllegalArgumentException("For schema '" + schema.name() + "': A search specification must have an equally named document inside of it.");
            }
            ParsedDocument doc = schema.getDocument();
            ParsedDocument old = this.parsedDocs.put(doc.name(), doc);
            if (old != null) {
                throw new IllegalArgumentException("duplicate document declaration for " + doc.name());
            }
            this.schemaForDocs.put(doc.name(), schema);
            for (String docInherit : doc.getInherited()) {
                schema.inheritByDocument(docInherit);
            }
            for (String docReferenced : doc.getReferencedDocuments()) {
                schema.inheritByDocument(docReferenced);
            }
        }
        for (ParsedDocument doc : this.parsedDocs.values()) {
            for (String inherit : doc.getInherited()) {
                ParsedDocument parentDoc = this.parsedDocs.get(inherit);
                if (parentDoc == null) {
                    throw new IllegalArgumentException("document " + doc.name() + " inherits from unavailable document " + inherit);
                }
                doc.resolveInherit(inherit, parentDoc);
            }
            for (String docRefName : doc.getReferencedDocuments()) {
                ParsedDocument refDoc = this.parsedDocs.get(docRefName);
                if (refDoc == null) {
                    throw new IllegalArgumentException("document " + doc.name() + " references unavailable document " + docRefName);
                }
                doc.resolveReferenced(refDoc);
            }
        }
        for (ParsedSchema schema : this.parsedSchemas.values()) {
            for (String docName : schema.getInheritedByDocument()) {
                ParsedSchema parent = this.schemaForDocs.get(docName);
                assert (parent.hasDocument());
                assert (parent.getDocument().name().equals(docName));
                schema.resolveInheritByDocument(docName, parent);
            }
        }
    }

    private void inheritanceCycleCheck(ParsedDocument document, List<String> seen) {
        String name = document.name();
        if (seen.contains(name)) {
            seen.add(name);
            throw new IllegalArgumentException("Inheritance/reference cycle for documents: " + String.join((CharSequence)" -> ", seen));
        }
        seen.add(name);
        for (ParsedDocument parent : document.getAllResolvedParents()) {
            this.inheritanceCycleCheck(parent, seen);
        }
        seen.remove(name);
    }

    private void checkDocumentCycles() {
        ArrayList<String> seen = new ArrayList<String>();
        for (ParsedDocument doc : this.parsedDocs.values()) {
            this.inheritanceCycleCheck(doc, seen);
        }
    }

    public void resolveInheritance() {
        this.resolveSchemaInheritance();
        this.resolveDocumentInheritance();
        this.checkDocumentCycles();
        this.checkSchemaCycles();
    }
}

