/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.parser.ParsedRankFunction;
import com.yahoo.searchdefinition.parser.ParsedRankProfile;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import java.util.List;
import java.util.Map;

public class ConvertParsedRanking {
    private final RankProfileRegistry rankProfileRegistry;

    ConvertParsedRanking() {
        this(new RankProfileRegistry());
    }

    public ConvertParsedRanking(RankProfileRegistry rankProfileRegistry) {
        this.rankProfileRegistry = rankProfileRegistry;
    }

    private RankProfile makeRankProfile(Schema schema, String name) {
        if (name.equals("default")) {
            return this.rankProfileRegistry.get(schema, "default");
        }
        return new RankProfile(name, schema, this.rankProfileRegistry);
    }

    void convertRankProfile(Schema schema, ParsedRankProfile parsed) {
        RankProfile profile = this.makeRankProfile(schema, parsed.name());
        for (String string : parsed.getInherited()) {
            profile.inherit(string);
        }
        parsed.isStrict().ifPresent(value -> profile.setStrict((Boolean)value));
        for (RankProfile.Constant constant : parsed.getConstants().values()) {
            profile.add(constant);
        }
        for (OnnxModel onnxModel : parsed.getOnnxModels()) {
            profile.add(onnxModel);
        }
        for (Map.Entry entry : parsed.getInputs().entrySet()) {
            profile.addInput((Reference)entry.getKey(), (RankProfile.Input)entry.getValue());
        }
        for (ParsedRankFunction parsedRankFunction : parsed.getFunctions()) {
            String name = parsedRankFunction.name();
            List<String> parameters = parsedRankFunction.getParameters();
            String expression = parsedRankFunction.getExpression();
            boolean inline = parsedRankFunction.getInline();
            profile.addFunction(name, parameters, expression, inline);
        }
        parsed.getRankScoreDropLimit().ifPresent(value -> profile.setRankScoreDropLimit((double)value));
        parsed.getTermwiseLimit().ifPresent(value -> profile.setTermwiseLimit((double)value));
        parsed.getPostFilterThreshold().ifPresent(value -> profile.setPostFilterThreshold((double)value));
        parsed.getApproximateThreshold().ifPresent(value -> profile.setApproximateThreshold((double)value));
        parsed.getKeepRankCount().ifPresent(value -> profile.setKeepRankCount((int)value));
        parsed.getMinHitsPerThread().ifPresent(value -> profile.setMinHitsPerThread((int)value));
        parsed.getNumSearchPartitions().ifPresent(value -> profile.setNumSearchPartitions((int)value));
        parsed.getNumThreadsPerSearch().ifPresent(value -> profile.setNumThreadsPerSearch((int)value));
        parsed.getReRankCount().ifPresent(value -> profile.setRerankCount((int)value));
        parsed.getMatchPhaseSettings().ifPresent(value -> profile.setMatchPhaseSettings((RankProfile.MatchPhaseSettings)value));
        parsed.getFirstPhaseExpression().ifPresent(value -> profile.setFirstPhaseRanking((String)value));
        parsed.getSecondPhaseExpression().ifPresent(value -> profile.setSecondPhaseRanking((String)value));
        for (FeatureList featureList : parsed.getMatchFeatures()) {
            profile.addMatchFeatures(featureList);
        }
        for (FeatureList featureList : parsed.getRankFeatures()) {
            profile.addRankFeatures(featureList);
        }
        for (FeatureList featureList : parsed.getSummaryFeatures()) {
            profile.addSummaryFeatures(featureList);
        }
        parsed.getInheritedMatchFeatures().ifPresent(value -> profile.setInheritedMatchFeatures((String)value));
        parsed.getInheritedSummaryFeatures().ifPresent(value -> profile.setInheritedSummaryFeatures((String)value));
        if (parsed.getIgnoreDefaultRankFeatures()) {
            profile.setIgnoreDefaultRankFeatures(true);
        }
        for (RankProfile.MutateOperation mutateOperation : parsed.getMutateOperations()) {
            profile.addMutateOperation(mutateOperation);
        }
        parsed.getFieldsWithRankFilter().forEach((fieldName, isFilter) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.PREFERBITVECTOR, isFilter));
        parsed.getFieldsWithRankWeight().forEach((fieldName, weight) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.WEIGHT, weight));
        parsed.getFieldsWithRankType().forEach((fieldName, rankType) -> profile.addRankSetting((String)fieldName, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.fromString(rankType)));
        parsed.getRankProperties().forEach((key, values) -> {
            for (String value : values) {
                profile.addRankProperty((String)key, value);
            }
        });
        this.rankProfileRegistry.add(profile);
    }
}

