/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.FieldResultTransform;
import com.yahoo.searchdefinition.derived.Summaries;
import com.yahoo.searchdefinition.derived.SummaryClass;
import com.yahoo.searchdefinition.derived.SummaryClassField;
import com.yahoo.searchdefinition.derived.SummaryMap;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SchemaInfo
extends Derived
implements SchemaInfoConfig.Producer {
    private final Schema schema;
    private final Map<String, RankProfileInfo> rankProfiles;
    private final Summaries summaries;
    private final SummaryMap summaryMap;

    public SchemaInfo(Schema schema, RankProfileRegistry rankProfileRegistry, Summaries summaries, SummaryMap summaryMap) {
        this.schema = schema;
        this.rankProfiles = Collections.unmodifiableMap(this.toRankProfiles(rankProfileRegistry.rankProfilesOf(schema)));
        this.summaries = summaries;
        this.summaryMap = summaryMap;
    }

    public String name() {
        return this.schema.getName();
    }

    @Override
    public String getDerivedName() {
        return "schema-info";
    }

    public Schema fullSchema() {
        return this.schema;
    }

    public Map<String, RankProfileInfo> rankProfiles() {
        return this.rankProfiles;
    }

    private Map<String, RankProfileInfo> toRankProfiles(Collection<RankProfile> rankProfiles) {
        LinkedHashMap<String, RankProfileInfo> rankProfileInfos = new LinkedHashMap<String, RankProfileInfo>();
        rankProfiles.forEach(profile -> rankProfileInfos.put(profile.name(), new RankProfileInfo((RankProfile)profile)));
        return rankProfileInfos;
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        SchemaInfoConfig.Schema.Builder schemaBuilder = new SchemaInfoConfig.Schema.Builder();
        schemaBuilder.name(this.schema.getName());
        this.addSummaryConfig(schemaBuilder);
        this.addRankProfilesConfig(schemaBuilder);
        builder.schema(schemaBuilder);
    }

    private void addSummaryConfig(SchemaInfoConfig.Schema.Builder schemaBuilder) {
        for (SummaryClass summary : this.summaries.asList()) {
            SchemaInfoConfig.Schema.Summaryclass.Builder summaryBuilder = new SchemaInfoConfig.Schema.Summaryclass.Builder();
            summaryBuilder.name(summary.getName());
            for (SummaryClassField field : summary.fields().values()) {
                SchemaInfoConfig.Schema.Summaryclass.Fields.Builder fieldsBuilder = new SchemaInfoConfig.Schema.Summaryclass.Fields.Builder();
                fieldsBuilder.name(field.getName()).type(field.getType().getName()).dynamic(this.isDynamic(field.getName()));
                summaryBuilder.fields(fieldsBuilder);
            }
            schemaBuilder.summaryclass(summaryBuilder);
        }
    }

    private boolean isDynamic(String fieldName) {
        if (this.summaryMap == null) {
            return false;
        }
        FieldResultTransform fieldTransform = this.summaryMap.resultTransforms().get(fieldName);
        if (fieldTransform == null) {
            return false;
        }
        return fieldTransform.getTransform().isDynamic() || fieldTransform.getTransform() == SummaryTransform.MATCHED_ELEMENTS_FILTER || fieldTransform.getTransform() == SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER;
    }

    private void addRankProfilesConfig(SchemaInfoConfig.Schema.Builder schemaBuilder) {
        for (RankProfileInfo rankProfile : this.rankProfiles().values()) {
            SchemaInfoConfig.Schema.Rankprofile.Builder rankProfileConfig = new SchemaInfoConfig.Schema.Rankprofile.Builder();
            rankProfileConfig.name(rankProfile.name());
            rankProfileConfig.hasSummaryFeatures(rankProfile.hasSummaryFeatures());
            rankProfileConfig.hasRankFeatures(rankProfile.hasRankFeatures());
            for (Map.Entry<Reference, RankProfile.Input> input : rankProfile.inputs().entrySet()) {
                SchemaInfoConfig.Schema.Rankprofile.Input.Builder inputConfig = new SchemaInfoConfig.Schema.Rankprofile.Input.Builder();
                inputConfig.name(input.getKey().toString());
                inputConfig.type(input.getValue().type().toString());
                rankProfileConfig.input(inputConfig);
            }
            schemaBuilder.rankprofile(rankProfileConfig);
        }
    }

    public static final class RankProfileInfo {
        private final String name;
        private final boolean hasSummaryFeatures;
        private final boolean hasRankFeatures;
        private final Map<Reference, RankProfile.Input> inputs;

        public RankProfileInfo(RankProfile profile) {
            this.name = profile.name();
            this.hasSummaryFeatures = !profile.getSummaryFeatures().isEmpty();
            this.hasRankFeatures = !profile.getRankFeatures().isEmpty();
            this.inputs = profile.inputs();
        }

        public String name() {
            return this.name;
        }

        public boolean hasSummaryFeatures() {
            return this.hasSummaryFeatures;
        }

        public boolean hasRankFeatures() {
            return this.hasRankFeatures;
        }

        public Map<Reference, RankProfile.Input> inputs() {
            return this.inputs;
        }
    }
}

