/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.collections.Pair;
import com.yahoo.searchdefinition.derived.NativeTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FieldRankSettings {
    private final String fieldName;
    private final Map<String, NativeTable> tables = new LinkedHashMap<String, NativeTable>();

    public FieldRankSettings(String fieldName) {
        this.fieldName = fieldName;
    }

    public void addTable(NativeTable table) {
        NativeTable existing = this.tables.get(table.getType().getName());
        if (existing != null) {
            return;
        }
        this.tables.put(table.getType().getName(), table);
    }

    public static boolean isIndexFieldTable(NativeTable table) {
        return FieldRankSettings.isFieldMatchTable(table) || FieldRankSettings.isProximityTable(table);
    }

    public static boolean isAttributeFieldTable(NativeTable table) {
        return FieldRankSettings.isAttributeMatchTable(table);
    }

    private static boolean isFieldMatchTable(NativeTable table) {
        return table.getType().equals(NativeTable.Type.FIRST_OCCURRENCE) || table.getType().equals(NativeTable.Type.OCCURRENCE_COUNT);
    }

    private static boolean isAttributeMatchTable(NativeTable table) {
        return table.getType().equals(NativeTable.Type.WEIGHT);
    }

    private static boolean isProximityTable(NativeTable table) {
        return table.getType().equals(NativeTable.Type.PROXIMITY) || table.getType().equals(NativeTable.Type.REVERSE_PROXIMITY);
    }

    public List<Pair<String, String>> deriveRankProperties() {
        ArrayList<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();
        for (NativeTable table : this.tables.values()) {
            if (FieldRankSettings.isFieldMatchTable(table)) {
                properties.add((Pair<String, String>)new Pair((Object)("nativeFieldMatch." + table.getType().getName() + "." + this.fieldName), (Object)table.getName()));
            }
            if (FieldRankSettings.isAttributeMatchTable(table)) {
                properties.add((Pair<String, String>)new Pair((Object)("nativeAttributeMatch." + table.getType().getName() + "." + this.fieldName), (Object)table.getName()));
            }
            if (!FieldRankSettings.isProximityTable(table)) continue;
            properties.add((Pair<String, String>)new Pair((Object)("nativeProximity." + table.getType().getName() + "." + this.fieldName), (Object)table.getName()));
        }
        return properties;
    }

    public String toString() {
        return "rank settings of field " + this.fieldName;
    }
}

