/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.DefaultRankProfile;
import com.yahoo.searchdefinition.ImmutableSchema;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.UnrankedRankProfile;
import com.yahoo.searchdefinition.document.SDDocumentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RankProfileRegistry {
    private final Map<String, Map<String, RankProfile>> rankProfiles = new LinkedHashMap<String, Map<String, RankProfile>>();
    private static final String globalRankProfilesKey = "[global]";
    static final Set<String> overridableRankProfileNames = new HashSet<String>(Arrays.asList("default", "unranked"));

    public static RankProfileRegistry createRankProfileRegistryWithBuiltinRankProfiles(Schema schema) {
        RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
        rankProfileRegistry.add(new DefaultRankProfile(schema, rankProfileRegistry));
        rankProfileRegistry.add(new UnrankedRankProfile(schema, rankProfileRegistry));
        return rankProfileRegistry;
    }

    private String extractName(ImmutableSchema search) {
        return search != null ? search.getName() : globalRankProfilesKey;
    }

    public void add(RankProfile rankProfile) {
        String schemaName = this.extractName(rankProfile.schema());
        if (!this.rankProfiles.containsKey(schemaName)) {
            this.rankProfiles.put(schemaName, new LinkedHashMap());
        }
        this.checkForDuplicate(rankProfile);
        this.rankProfiles.get(schemaName).put(rankProfile.name(), rankProfile);
    }

    private void checkForDuplicate(RankProfile rankProfile) {
        String rankProfileName = rankProfile.name();
        RankProfile existingRankProfileWithSameName = this.rankProfiles.get(this.extractName(rankProfile.schema())).get(rankProfileName);
        if (existingRankProfileWithSameName == null) {
            return;
        }
        if (!overridableRankProfileNames.contains(rankProfileName)) {
            throw new IllegalArgumentException("Duplicate rank profile '" + rankProfileName + "' in " + rankProfile.schema());
        }
    }

    public RankProfile get(String schema, String name) {
        Map<String, RankProfile> profiles = this.rankProfiles.get(schema);
        if (profiles == null) {
            return null;
        }
        return profiles.get(name);
    }

    public RankProfile get(ImmutableSchema schema, String name) {
        RankProfile profile = this.get(schema.getName(), name);
        if (profile != null) {
            return profile;
        }
        if (schema.inherited().isPresent()) {
            return this.get(schema.inherited().get(), name);
        }
        return null;
    }

    public RankProfile getGlobal(String name) {
        Map<String, RankProfile> profiles = this.rankProfiles.get(globalRankProfilesKey);
        if (profiles == null) {
            return null;
        }
        return profiles.get(name);
    }

    public RankProfile resolve(SDDocumentType docType, String name) {
        RankProfile rankProfile = this.get(docType.getName(), name);
        if (rankProfile != null) {
            return rankProfile;
        }
        for (SDDocumentType parent : docType.getInheritedTypes()) {
            RankProfile parentProfile = this.resolve(parent, name);
            if (parentProfile == null) continue;
            return parentProfile;
        }
        return this.get(globalRankProfilesKey, name);
    }

    public Collection<RankProfile> all() {
        ArrayList<RankProfile> all = new ArrayList<RankProfile>();
        for (Map<String, RankProfile> entry : this.rankProfiles.values()) {
            all.addAll(entry.values());
        }
        return all;
    }

    public Collection<RankProfile> rankProfilesOf(ImmutableSchema schema) {
        String key;
        String string = key = schema == null ? globalRankProfilesKey : schema.getName();
        if (!this.rankProfiles.containsKey(key)) {
            return List.of();
        }
        LinkedHashMap<String, RankProfile> profiles = new LinkedHashMap<String, RankProfile>(this.rankProfiles.get(key));
        while (schema != null && schema.inherited().isPresent()) {
            Map<String, RankProfile> inheritedProfiles = this.rankProfiles.get((schema = schema.inherited().get()).getName());
            if (inheritedProfiles == null) continue;
            for (Map.Entry<String, RankProfile> inheritedProfile : inheritedProfiles.entrySet()) {
                profiles.putIfAbsent(inheritedProfile.getKey(), inheritedProfile.getValue());
            }
        }
        return profiles.values();
    }
}

