/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.document.Field;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocumentReferenceResolver {
    private final Map<String, Schema> schemaMapping;

    public DocumentReferenceResolver(Collection<Schema> schemas) {
        this.schemaMapping = DocumentReferenceResolver.createDocumentNameToSearchMapping(schemas);
    }

    public void resolveReferences(SDDocumentType documentType) {
        DocumentReferences references = new DocumentReferences(this.createFieldToDocumentReferenceMapping(documentType));
        documentType.setDocumentReferences(references);
    }

    public void resolveInheritedReferences(SDDocumentType documentType) {
        this.resolveInheritedReferencesRecursive(documentType, documentType.getInheritedTypes());
    }

    private void resolveInheritedReferencesRecursive(SDDocumentType documentType, Collection<SDDocumentType> inheritedTypes) {
        for (SDDocumentType inheritedType : inheritedTypes) {
            documentType.getDocumentReferences().get().mergeFrom(inheritedType.getDocumentReferences().get());
        }
        for (SDDocumentType inheritedType : inheritedTypes) {
            this.resolveInheritedReferencesRecursive(documentType, inheritedType.getInheritedTypes());
        }
    }

    private Map<String, DocumentReference> createFieldToDocumentReferenceMapping(SDDocumentType documentType) {
        return DocumentReferenceResolver.fieldStream(documentType).filter(field -> field.getDataType() instanceof NewDocumentReferenceDataType).collect(Collectors.toMap(FieldBase::getName, this::createDocumentReference));
    }

    private DocumentReference createDocumentReference(Field field) {
        if (!DocumentReferenceResolver.isAttribute(field)) {
            throw new IllegalArgumentException(String.format("The field '%s' is an invalid document reference. The field must be an attribute.", field.getName()));
        }
        NewDocumentReferenceDataType reference = (NewDocumentReferenceDataType)field.getDataType();
        String targetDocumentName = DocumentReferenceResolver.getTargetDocumentName(reference);
        Schema schema = this.schemaMapping.get(targetDocumentName);
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Invalid document reference '%s': Could not find document type '%s'", field.getName(), targetDocumentName));
        }
        return new DocumentReference(field, schema);
    }

    private static boolean isAttribute(Field field) {
        SDField sdField = (SDField)field;
        return sdField.doesAttributing();
    }

    private static Map<String, Schema> createDocumentNameToSearchMapping(Collection<Schema> schemaDefintions) {
        return schemaDefintions.stream().filter(search -> search.getDocument() != null).collect(Collectors.toMap(search -> search.getDocument().getName(), Function.identity()));
    }

    private static Stream<Field> fieldStream(SDDocumentType documentType) {
        return documentType.getDocumentType().getFields().stream();
    }

    private static String getTargetDocumentName(NewDocumentReferenceDataType reference) {
        return reference.getTargetTypeName();
    }
}

