/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.TuningDispatch;

public class DomTuningDispatchBuilder {
    public static TuningDispatch build(ModelElement contentXml) {
        TuningDispatch.Builder builder = new TuningDispatch.Builder();
        ModelElement tuningElement = contentXml.child("tuning");
        if (tuningElement == null) {
            return builder.build();
        }
        ModelElement dispatchElement = tuningElement.child("dispatch");
        if (dispatchElement == null) {
            return builder.build();
        }
        builder.setMaxHitsPerPartition(dispatchElement.childAsInteger("max-hits-per-partition"));
        builder.setDispatchPolicy(dispatchElement.childAsString("dispatch-policy"));
        builder.setUseLocalNode(dispatchElement.childAsBoolean("use-local-node"));
        builder.setMinGroupCoverage(dispatchElement.childAsDouble("min-group-coverage"));
        builder.setMinActiveDocsCoverage(dispatchElement.childAsDouble("min-active-docs-coverage"));
        return builder.build();
    }
}

