/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.component.ComponentId;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.QrConfig;
import com.yahoo.container.core.ContainerHttpConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ComponentsConfigGenerator;
import com.yahoo.vespa.model.container.component.DiscBindingsConfigGenerator;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;

@RestartConfigs(value={QrStartConfig.class, QrConfig.class})
public abstract class Container
extends AbstractService
implements QrConfig.Producer,
ComponentsConfig.Producer,
JdiscBindingsConfig.Producer,
ContainerHttpConfig.Producer,
ContainerMbusConfig.Producer {
    public static final int BASEPORT = Defaults.getDefaults().vespaWebServicePort();
    public static final String SINGLENODE_CONTAINER_SERVICESPEC = "default_singlenode_container";
    protected final AbstractConfigProducer parent;
    private final String name;
    private boolean requireSpecificPorts = true;
    private String clusterName = null;
    private Optional<String> hostResponseHeaderKey = Optional.empty();
    private final boolean retired;
    private final int index;
    private final ComponentGroup<Handler<?>> handlers = new ComponentGroup(this, "handler");
    private final ComponentGroup<Component<?, ?>> components = new ComponentGroup(this, "components");
    private final JettyHttpServer defaultHttpServer = new JettyHttpServer(new ComponentId("DefaultHttpServer"));
    protected final int numHttpServerPorts;
    private ContainerServiceType myServiceType = null;

    protected Container(AbstractConfigProducer parent, String name, int index) {
        this(parent, name, false, index);
    }

    protected Container(AbstractConfigProducer parent, String name, boolean retired, int index) {
        super(parent, name);
        this.name = name;
        this.parent = parent;
        this.retired = retired;
        this.index = index;
        if (this.getHttp() == null) {
            this.numHttpServerPorts = 2;
            this.addChild(this.defaultHttpServer);
        } else {
            this.numHttpServerPorts = this.getHttp().getHttpServer() == null ? 0 : this.getHttp().getHttpServer().getConnectorFactories().size();
        }
        this.addBuiltinHandlers();
        this.addChild(new SimpleComponent("com.yahoo.container.jdisc.ConfiguredApplication$ApplicationContext"));
    }

    public boolean isRetired() {
        return this.retired;
    }

    public ComponentGroup<Handler<?>> getHandlers() {
        return this.handlers;
    }

    public ComponentGroup getComponents() {
        return this.components;
    }

    public final void addComponent(Component c) {
        this.components.addComponent(c);
    }

    public final void addSimpleComponent(String idSpec, String classSpec, String bundleSpec) {
        this.addComponent(new SimpleComponent(new ComponentModel(idSpec, classSpec, bundleSpec)));
    }

    public final void addHandler(Handler h) {
        this.handlers.addComponent(h);
    }

    public void setHostResponseHeaderKey(Optional<String> hostResponseheaderKey) {
        Objects.requireNonNull(hostResponseheaderKey, "HostResponseheaderKey cannot be null");
        this.hostResponseHeaderKey = hostResponseheaderKey;
    }

    public Http getHttp() {
        return this.parent instanceof ContainerCluster ? ((ContainerCluster)this.parent).getHttp() : null;
    }

    public JettyHttpServer getDefaultHttpServer() {
        return this.defaultHttpServer;
    }

    public final int index() {
        return this.index;
    }

    public void addBuiltinHandlers() {
    }

    @Override
    public void initService(DeployLogger deployLogger) {
        if (this.isInitialized()) {
            return;
        }
        super.initService(deployLogger);
        if (this.getHttp() == null) {
            this.initDefaultJettyConnector();
        } else {
            this.reserveHttpPortsPrepended();
        }
        this.tagServers();
    }

    protected void tagServers() {
        int offset = 0;
        if (this.numHttpServerPorts > 0) {
            this.portsMeta.on(offset++).tag("http").tag("query").tag("external").tag("state");
        }
        for (int i = 1; i < this.numHttpServerPorts; ++i) {
            this.portsMeta.on(offset++).tag("http").tag("external");
        }
        if (this.messageBusEnabled()) {
            this.portsMeta.on(offset++).tag("rpc").tag("messaging");
        }
        if (this.rpcServerEnabled()) {
            this.portsMeta.on(offset++).tag("rpc").tag("admin");
        }
    }

    private void reserveHttpPortsPrepended() {
        if (this.getHttp() != null && this.getHttp().getHttpServer() != null) {
            for (ConnectorFactory connectorFactory : this.getHttp().getHttpServer().getConnectorFactories()) {
                this.reservePortPrepended(this.getPort(connectorFactory), "http/" + connectorFactory.getName());
            }
        }
    }

    private int getPort(ConnectorFactory connectorFactory) {
        return connectorFactory.getListenPort();
    }

    private void initDefaultJettyConnector() {
        this.defaultHttpServer.addConnector(new ConnectorFactory("SearchServer", this.getSearchPort()));
    }

    @Override
    public final String getServiceType() {
        if (this.myServiceType == null) {
            this.myServiceType = this.myServiceType();
        }
        return this.myServiceType.serviceName;
    }

    protected abstract ContainerServiceType myServiceType();

    public void setClusterName(String name) {
        this.clusterName = name;
    }

    @Override
    public int getWantedPort() {
        return this.requiresWantedPort() ? BASEPORT : 0;
    }

    public void useDynamicPorts() {
        this.requireSpecificPorts = false;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.requireSpecificPorts && this.getHttp() == null;
    }

    @Override
    public boolean requiresConsecutivePorts() {
        return false;
    }

    @Override
    public int getPortCount() {
        int httpPorts = this.getHttp() != null ? 0 : this.numHttpServerPorts + 2;
        return httpPorts + this.numMessageBusPorts() + this.numRpcPorts();
    }

    @Override
    public String[] getPortSuffixes() {
        int httpPorts;
        int n = this.getPortCount();
        String[] suffixes = new String[n];
        int off = 0;
        int n2 = httpPorts = this.getHttp() != null ? 0 : this.numHttpServerPorts;
        if (httpPorts > 0) {
            suffixes[off++] = "http";
        }
        for (int i = 1; i < httpPorts; ++i) {
            suffixes[off++] = "http/" + i;
        }
        if (this.messageBusEnabled()) {
            suffixes[off++] = "messaging";
        }
        if (this.rpcServerEnabled()) {
            suffixes[off++] = "rpc/admin";
        }
        while (off < n) {
            suffixes[off] = "unused/" + off;
            ++off;
        }
        assert (off == n);
        return suffixes;
    }

    public int getSearchPort() {
        if (this.getHttp() != null) {
            throw new AssertionError((Object)"getSearchPort must not be used when http section is present.");
        }
        return this.getRelativePort(0);
    }

    private int getRpcPort() {
        return this.rpcServerEnabled() ? this.getRelativePort(this.numHttpServerPorts + this.numMessageBusPorts()) : 0;
    }

    protected int numRpcPorts() {
        return this.rpcServerEnabled() ? 1 : 0;
    }

    private int getMessagingPort() {
        return this.messageBusEnabled() ? this.getRelativePort(this.numHttpServerPorts) : 0;
    }

    protected int numMessageBusPorts() {
        return this.messageBusEnabled() ? 1 : 0;
    }

    @Override
    public int getHealthPort() {
        Http http = this.getHttp();
        if (http != null) {
            if (http.getHttpServer() == null) {
                return -1;
            }
            return this.getRelativePort(0);
        }
        return this.httpServerEnabled() ? this.getSearchPort() : -1;
    }

    @Override
    public String getStartupCommand() {
        return "PRELOAD=" + this.getPreLoad() + " exec vespa-start-container-daemon " + this.getJvmOptions() + " ";
    }

    public void getConfig(QrConfig.Builder builder) {
        builder.rpc(new QrConfig.Rpc.Builder().enabled(this.rpcServerEnabled()).port(this.getRpcPort()).slobrokId(this.serviceSlobrokId())).filedistributor(this.filedistributorConfig());
        if (this.clusterName != null) {
            builder.discriminator(this.clusterName + "." + this.name);
        } else {
            builder.discriminator(this.name);
        }
    }

    public String getAssignedJvmOptions() {
        return super.getJvmOptions();
    }

    private String serviceSlobrokId() {
        return "vespa/service/" + this.getConfigId();
    }

    private QrConfig.Filedistributor.Builder filedistributorConfig() {
        QrConfig.Filedistributor.Builder builder = new QrConfig.Filedistributor.Builder();
        FileDistributionConfigProducer fileDistribution = this.getRoot().getFileDistributionConfigProducer();
        if (fileDistribution != null) {
            builder.configid(fileDistribution.getConfigProducer(this.getHost()).getConfigId());
        }
        return builder;
    }

    public void getConfig(ComponentsConfig.Builder builder) {
        builder.components.addAll(ComponentsConfigGenerator.generate(this.allEnabledComponents()));
    }

    private Collection<Component<?, ?>> allEnabledComponents() {
        ArrayList allComponents = new ArrayList();
        this.addAllEnabledComponents(allComponents, this);
        return Collections.unmodifiableCollection(allComponents);
    }

    private void addAllEnabledComponents(Collection<Component<?, ?>> allComponents, AbstractConfigProducer<?> current) {
        for (AbstractConfigProducer child : current.getChildren().values()) {
            if (!this.httpServerEnabled() && this.isHttpServer(child)) continue;
            if (child instanceof Component) {
                allComponents.add((Component)child);
            }
            this.addAllEnabledComponents(allComponents, child);
        }
    }

    private boolean isHttpServer(AbstractConfigProducer<?> component) {
        return component instanceof JettyHttpServer;
    }

    public final void getConfig(JdiscBindingsConfig.Builder builder) {
        builder.handlers(DiscBindingsConfigGenerator.generate(this.handlers.getComponents()));
    }

    public void getConfig(ContainerHttpConfig.Builder builder) {
        if (this.hostResponseHeaderKey.isPresent()) {
            builder.hostResponseHeaderKey(this.hostResponseHeaderKey.get());
        }
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        builder.enabled(this.messageBusEnabled()).port(this.getMessagingPort());
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (this.clusterName != null) {
            dimensions.put("clustername", this.clusterName);
        }
        return dimensions;
    }

    private boolean messageBusEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().messageBusEnabled();
    }

    private boolean httpServerEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().httpServerEnabled();
    }

    private boolean rpcServerEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().rpcServerEnabled();
    }

    private Optional<ContainerCluster> containerCluster() {
        return this.parent instanceof ContainerCluster ? Optional.of((ContainerCluster)this.parent) : Optional.empty();
    }
}

