/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DisallowComplexMapAndWsetKeyTypes
extends Processor {
    public DisallowComplexMapAndWsetKeyTypes(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.search.allConcreteFields()) {
            this.checkFieldType(field, field.getDataType());
        }
    }

    private void checkFieldType(SDField field, DataType dataType) {
        if (dataType instanceof ArrayDataType) {
            DataType nestedType = ((ArrayDataType)dataType).getNestedType();
            this.checkFieldType(field, nestedType);
        } else if (dataType instanceof WeightedSetDataType) {
            DataType nestedType = ((WeightedSetDataType)dataType).getNestedType();
            if (!(nestedType instanceof PrimitiveDataType)) {
                this.fail(this.search, field, "Weighted set must have a primitive key type.");
            }
        } else if (dataType instanceof MapDataType) {
            DataType keyType = ((MapDataType)dataType).getKeyType();
            if (!(keyType instanceof PrimitiveDataType)) {
                this.fail(this.search, field, "Map key type must be a primitive type.");
            }
            this.checkFieldType(field, ((MapDataType)dataType).getValueType());
        }
    }
}

