/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Float16FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.searchdefinition.document.Sorting;
import com.yahoo.tensor.TensorType;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class Attribute
implements Cloneable,
Serializable {
    private String name;
    private Type type;
    private CollectionType collectionType;
    private boolean removeIfZero = false;
    private boolean createIfNonExistent = false;
    private boolean enableBitVectors = false;
    private boolean enableOnlyBitVector = false;
    private boolean fastSearch = false;
    private boolean fastAccess = false;
    private boolean huge = false;
    private boolean mutable = false;
    private int arity = 8;
    private long lowerBound = Long.MIN_VALUE;
    private long upperBound = Long.MAX_VALUE;
    private double densePostingListThreshold = 0.4;
    private Optional<TensorType> tensorType = Optional.empty();
    private final Optional<StructuredDataType> referenceDocumentType;
    private boolean isPosition = false;
    private final Sorting sorting = new Sorting();
    private final Set<String> aliases = new LinkedHashSet<String>();
    private Boolean prefetch = null;

    public Attribute(String name, DataType fieldType) {
        this(name, Attribute.convertDataType(fieldType), Attribute.convertCollectionType(fieldType), Attribute.convertTensorType(fieldType), Attribute.convertTargetType(fieldType));
        this.setRemoveIfZero(fieldType instanceof WeightedSetDataType ? ((WeightedSetDataType)fieldType).removeIfZero() : false);
        this.setCreateIfNonExistent(fieldType instanceof WeightedSetDataType ? ((WeightedSetDataType)fieldType).createIfNonExistent() : false);
    }

    public Attribute(String name, Type type, CollectionType collectionType) {
        this(name, type, collectionType, Optional.empty(), Optional.empty());
    }

    public Attribute(String name, Type type, CollectionType collectionType, Optional<TensorType> tensorType, Optional<StructuredDataType> referenceDocumentType) {
        this.name = name;
        this.setType(type);
        this.setCollectionType(collectionType);
        this.tensorType = tensorType;
        this.referenceDocumentType = referenceDocumentType;
    }

    public Attribute convertToArray() {
        Attribute result = this.clone();
        result.collectionType = CollectionType.ARRAY;
        return result;
    }

    public boolean isPrefetch() {
        if (this.prefetch != null) {
            return this.prefetch;
        }
        return CollectionType.SINGLE.equals((Object)this.collectionType);
    }

    public Boolean getPrefetchValue() {
        return this.prefetch;
    }

    public boolean isRemoveIfZero() {
        return this.removeIfZero;
    }

    public boolean isCreateIfNonExistent() {
        return this.createIfNonExistent;
    }

    public boolean isEnabledBitVectors() {
        return this.enableBitVectors;
    }

    public boolean isEnabledOnlyBitVector() {
        return this.enableOnlyBitVector;
    }

    public boolean isFastSearch() {
        return this.fastSearch;
    }

    public boolean isFastAccess() {
        return this.fastAccess;
    }

    public boolean isHuge() {
        return this.huge;
    }

    public boolean isPosition() {
        return this.isPosition;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int arity() {
        return this.arity;
    }

    public long lowerBound() {
        return this.lowerBound;
    }

    public long upperBound() {
        return this.upperBound;
    }

    public double densePostingListThreshold() {
        return this.densePostingListThreshold;
    }

    public Optional<TensorType> tensorType() {
        return this.tensorType;
    }

    public Optional<StructuredDataType> referenceDocumentType() {
        return this.referenceDocumentType;
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public void setRemoveIfZero(boolean remove) {
        this.removeIfZero = remove;
    }

    public void setCreateIfNonExistent(boolean create) {
        this.createIfNonExistent = create;
    }

    public void setPrefetch(Boolean prefetch) {
        this.prefetch = prefetch;
    }

    public void setEnableBitVectors(boolean enableBitVectors) {
        this.enableBitVectors = enableBitVectors;
    }

    public void setEnableOnlyBitVector(boolean enableOnlyBitVector) {
        this.enableOnlyBitVector = enableOnlyBitVector;
    }

    public void setFastSearch(boolean fastSearch) {
        this.fastSearch = fastSearch;
    }

    public void setHuge(boolean huge) {
        this.huge = huge;
    }

    public void setFastAccess(boolean fastAccess) {
        this.fastAccess = fastAccess;
    }

    public void setPosition(boolean position) {
        this.isPosition = position;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public void setDensePostingListThreshold(double threshold) {
        this.densePostingListThreshold = threshold;
    }

    public void setTensorType(TensorType tensorType) {
        this.tensorType = Optional.of(tensorType);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public void setCollectionType(CollectionType type) {
        this.collectionType = type;
    }

    public static Type convertDataType(DataType fieldType) {
        FieldValue fval = fieldType.createFieldValue();
        if (fval instanceof StringFieldValue) {
            return Type.STRING;
        }
        if (fval instanceof IntegerFieldValue) {
            return Type.INTEGER;
        }
        if (fval instanceof LongFieldValue) {
            return Type.LONG;
        }
        if (fval instanceof FloatFieldValue) {
            return Type.FLOAT;
        }
        if (fval instanceof DoubleFieldValue) {
            return Type.DOUBLE;
        }
        if (fval instanceof BoolFieldValue) {
            return Type.BOOL;
        }
        if (fval instanceof Float16FieldValue) {
            return Type.FLOAT16;
        }
        if (fval instanceof ByteFieldValue) {
            return Type.BYTE;
        }
        if (fval instanceof Raw) {
            return Type.BYTE;
        }
        if (fval instanceof PredicateFieldValue) {
            return Type.PREDICATE;
        }
        if (fval instanceof TensorFieldValue) {
            return Type.TENSOR;
        }
        if (fieldType instanceof CollectionDataType) {
            return Attribute.convertDataType(((CollectionDataType)fieldType).getNestedType());
        }
        if (fieldType instanceof ReferenceDataType) {
            return Type.REFERENCE;
        }
        throw new IllegalArgumentException("Don't know which attribute type to convert " + fieldType + " to");
    }

    private static CollectionType convertCollectionType(DataType fieldType) {
        if (fieldType instanceof ArrayDataType) {
            return CollectionType.ARRAY;
        }
        if (fieldType instanceof WeightedSetDataType) {
            return CollectionType.WEIGHTEDSET;
        }
        if (fieldType instanceof TensorDataType) {
            return CollectionType.SINGLE;
        }
        if (fieldType instanceof PrimitiveDataType) {
            return CollectionType.SINGLE;
        }
        if (fieldType instanceof ReferenceDataType) {
            return CollectionType.SINGLE;
        }
        throw new IllegalArgumentException("Field " + fieldType + " not supported in convertCollectionType");
    }

    private static Optional<TensorType> convertTensorType(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            return Optional.empty();
        }
        return Optional.of(((TensorDataType)fieldType).getTensorType());
    }

    private static Optional<StructuredDataType> convertTargetType(DataType fieldType) {
        return Optional.of(fieldType).filter(ReferenceDataType.class::isInstance).map(ReferenceDataType.class::cast).map(ReferenceDataType::getTargetType);
    }

    private DataType toDataType(Type attributeType) {
        switch (attributeType) {
            case STRING: {
                return DataType.STRING;
            }
            case INTEGER: {
                return DataType.INT;
            }
            case LONG: {
                return DataType.LONG;
            }
            case FLOAT16: {
                return DataType.FLOAT16;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case BOOL: {
                return DataType.BOOL;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case PREDICATE: {
                return DataType.PREDICATE;
            }
            case TENSOR: {
                return DataType.getTensor((TensorType)this.tensorType.orElseThrow(IllegalStateException::new));
            }
            case REFERENCE: {
                return this.createReferenceDataType();
            }
        }
        throw new IllegalArgumentException("Unknown attribute type " + attributeType);
    }

    private DataType createReferenceDataType() {
        if (!this.referenceDocumentType.isPresent()) {
            throw new IllegalStateException("Referenced document type is not set!");
        }
        StructuredDataType type = this.referenceDocumentType.get();
        if (type instanceof DocumentType) {
            return ReferenceDataType.createWithInferredId((DocumentType)((DocumentType)type));
        }
        return ReferenceDataType.createWithInferredId((TemporaryStructuredDataType)((TemporaryStructuredDataType)type));
    }

    public DataType getDataType() {
        DataType dataType = this.toDataType(this.type);
        if (this.collectionType.equals((Object)CollectionType.ARRAY)) {
            return DataType.getArray((DataType)dataType);
        }
        if (this.collectionType.equals((Object)CollectionType.WEIGHTEDSET)) {
            return DataType.getWeightedSet((DataType)dataType, (boolean)this.createIfNonExistent, (boolean)this.removeIfZero);
        }
        return dataType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.collectionType, this.sorting, this.isPrefetch(), this.fastAccess, this.removeIfZero, this.createIfNonExistent, this.isPosition, this.huge, this.enableBitVectors, this.enableOnlyBitVector, this.tensorType, this.referenceDocumentType});
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)object;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.isCompatible(other);
    }

    public boolean isCompatible(Attribute other) {
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (!this.collectionType.equals((Object)other.collectionType)) {
            return false;
        }
        if (this.isPrefetch() != other.isPrefetch()) {
            return false;
        }
        if (this.removeIfZero != other.removeIfZero) {
            return false;
        }
        if (this.createIfNonExistent != other.createIfNonExistent) {
            return false;
        }
        if (this.enableBitVectors != other.enableBitVectors) {
            return false;
        }
        if (this.enableOnlyBitVector != other.enableOnlyBitVector) {
            return false;
        }
        if (this.fastSearch != other.fastSearch) {
            return false;
        }
        if (this.huge != other.huge) {
            return false;
        }
        if (!this.sorting.equals(other.sorting)) {
            return false;
        }
        if (!this.tensorType.equals(other.tensorType)) {
            return false;
        }
        return this.referenceDocumentType.equals(other.referenceDocumentType);
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    public String toString() {
        return "attribute '" + this.name + "' (" + this.type + ")";
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public static enum CollectionType {
        SINGLE("SINGLE"),
        ARRAY("ARRAY"),
        WEIGHTEDSET("WEIGHTEDSET");

        private final String name;

        private CollectionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "collectiontype: " + this.name;
        }
    }

    public static enum Type {
        BYTE("byte", "INT8"),
        SHORT("short", "INT16"),
        INTEGER("integer", "INT32"),
        LONG("long", "INT64"),
        FLOAT16("float16", "FLOAT16"),
        FLOAT("float", "FLOAT"),
        DOUBLE("double", "DOUBLE"),
        STRING("string", "STRING"),
        BOOL("bool", "BOOL"),
        PREDICATE("predicate", "PREDICATE"),
        TENSOR("tensor", "TENSOR"),
        REFERENCE("reference", "REFERENCE");

        private final String myName;
        private final String exportAttributeTypeName;

        private Type(String name, String exportAttributeTypeName) {
            this.myName = name;
            this.exportAttributeTypeName = exportAttributeTypeName;
        }

        public String getName() {
            return this.myName;
        }

        public String getExportAttributeTypeName() {
            return this.exportAttributeTypeName;
        }

        public String toString() {
            return "type: " + this.myName;
        }
    }
}

