/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;
import com.yahoo.searchdefinition.fieldoperation.FieldOperationContainer;
import com.yahoo.tensor.TensorType;
import java.util.Locale;
import java.util.Optional;

public class AttributeOperation
implements FieldOperation,
FieldOperationContainer {
    private final String name;
    private Boolean huge;
    private Boolean fastSearch;
    private Boolean fastAccess;
    private Boolean mutable;
    private Boolean paged;
    private Boolean enableBitVectors;
    private Boolean enableOnlyBitVector;
    private boolean doAlias = false;
    private String alias;
    private String aliasedName;
    private Optional<TensorType> tensorType = Optional.empty();
    private Optional<String> distanceMetric = Optional.empty();

    public AttributeOperation(String name) {
        this.name = name;
    }

    @Override
    public void addOperation(FieldOperation op) {
    }

    @Override
    public void applyOperations(SDField field) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Boolean getHuge() {
        return this.huge;
    }

    public void setHuge(Boolean huge) {
        this.huge = huge;
    }

    public Boolean getFastSearch() {
        return this.fastSearch;
    }

    public void setFastSearch(Boolean fastSearch) {
        this.fastSearch = fastSearch;
    }

    public Boolean getFastAccess() {
        return this.fastAccess;
    }

    public void setFastAccess(Boolean fastAccess) {
        this.fastAccess = fastAccess;
    }

    public void setMutable(Boolean mutable) {
        this.mutable = mutable;
    }

    public void setPaged(Boolean paged) {
        this.paged = paged;
    }

    public Boolean getEnableBitVectors() {
        return this.enableBitVectors;
    }

    public void setEnableBitVectors(Boolean enableBitVectors) {
        this.enableBitVectors = enableBitVectors;
    }

    public Boolean getEnableOnlyBitVector() {
        return this.enableOnlyBitVector;
    }

    public void setEnableOnlyBitVector(Boolean enableOnlyBitVector) {
        this.enableOnlyBitVector = enableOnlyBitVector;
    }

    public void setDoAlias(boolean doAlias) {
        this.doAlias = doAlias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAliasedName(String aliasedName) {
        this.aliasedName = aliasedName;
    }

    public void setTensorType(TensorType tensorType) {
        this.tensorType = Optional.of(tensorType);
    }

    public void setDistanceMetric(String value) {
        this.distanceMetric = Optional.of(value);
    }

    @Override
    public void apply(SDField field) {
        Attribute attribute = null;
        if (this.attributeIsSuffixOfStructField(field.getName())) {
            attribute = field.getAttributes().get(field.getName());
        }
        if (attribute == null && (attribute = field.getAttributes().get(this.name)) == null) {
            attribute = new Attribute(this.name, field.getDataType());
            field.addAttribute(attribute);
        }
        if (this.huge != null) {
            attribute.setHuge(this.huge);
        }
        if (this.paged != null) {
            attribute.setPaged(this.paged);
        }
        if (this.fastSearch != null) {
            attribute.setFastSearch(this.fastSearch);
        }
        if (this.fastAccess != null) {
            attribute.setFastAccess(this.fastAccess);
        }
        if (this.mutable != null) {
            attribute.setMutable(this.mutable);
        }
        if (this.enableBitVectors != null) {
            attribute.setEnableBitVectors(this.enableBitVectors);
        }
        if (this.enableOnlyBitVector != null) {
            attribute.setEnableOnlyBitVector(this.enableOnlyBitVector);
        }
        if (this.doAlias) {
            field.getAliasToName().put(this.alias, this.aliasedName);
        }
        if (this.tensorType.isPresent()) {
            attribute.setTensorType(this.tensorType.get());
        }
        if (this.distanceMetric.isPresent()) {
            String upper = this.distanceMetric.get().toUpperCase(Locale.ENGLISH);
            attribute.setDistanceMetric(Attribute.DistanceMetric.valueOf(upper));
        }
    }

    private boolean attributeIsSuffixOfStructField(String fieldName) {
        return fieldName.indexOf(46) != -1 && fieldName.endsWith(this.name);
    }
}

