/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.utils;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.model.AbstractService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class FileSender
implements Serializable {
    private final Collection<? extends AbstractService> services;
    private final FileRegistry fileRegistry;
    private final DeployLogger logger;

    public FileSender(Collection<? extends AbstractService> services, FileRegistry fileRegistry, DeployLogger logger) {
        this.services = services;
        this.fileRegistry = fileRegistry;
        this.logger = logger;
    }

    public static void send(FileReference fileReference, Collection<? extends AbstractService> services) {
        if (services.isEmpty()) {
            throw new IllegalStateException("No service instances. Probably a standalone cluster setting up <nodes> using 'count' instead of <node> tags.");
        }
        for (AbstractService abstractService : services) {
            abstractService.send(fileReference);
        }
    }

    public <PRODUCER extends AbstractConfigProducer<?>> void sendUserConfiguredFiles(PRODUCER producer) {
        if (this.services.isEmpty()) {
            return;
        }
        UserConfigRepo userConfigs = producer.getUserConfigs();
        HashMap<String, FileReference> sentFiles = new HashMap<String, FileReference>();
        for (ConfigDefinitionKey key : userConfigs.configsProduced()) {
            ConfigPayloadBuilder builder = userConfigs.get(key);
            try {
                this.sendUserConfiguredFiles(builder, sentFiles, key);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unable to send files for " + key, e);
            }
        }
    }

    private void sendUserConfiguredFiles(ConfigPayloadBuilder builder, Map<String, FileReference> sentFiles, ConfigDefinitionKey key) {
        ConfigPayloadBuilder.MapBuilder map;
        ConfigPayloadBuilder.Array array;
        ConfigDefinition configDefinition = builder.getConfigDefinition();
        if (configDefinition == null) {
            this.logger.logApplicationPackage(Level.FINE, "Not able to find config definition for " + key + ". Will not send files for this config");
            return;
        }
        this.sendEntries(builder, sentFiles, configDefinition.getFileDefs());
        this.sendEntries(builder, sentFiles, configDefinition.getPathDefs());
        for (Map.Entry<String, ConfigDefinition.ArrayDef> entry : configDefinition.getArrayDefs().entrySet()) {
            if (!FileSender.isFileOrPathArray(entry)) continue;
            array = builder.getArray(entry.getKey());
            this.sendFileEntries(array.getElements(), sentFiles);
        }
        for (Map.Entry<String, ConfigDefinition.LeafMapDef> entry : configDefinition.getLeafMapDefs().entrySet()) {
            if (!FileSender.isFileOrPathMap(entry)) continue;
            map = builder.getMap(entry.getKey());
            this.sendFileEntries(map.getElements(), sentFiles);
        }
        for (String string : configDefinition.getStructDefs().keySet()) {
            this.sendUserConfiguredFiles(builder.getObject(string), sentFiles, key);
        }
        for (String string : configDefinition.getInnerArrayDefs().keySet()) {
            array = builder.getArray(string);
            for (ConfigPayloadBuilder element : array.getElements()) {
                this.sendUserConfiguredFiles(element, sentFiles, key);
            }
        }
        for (String string : configDefinition.getStructMapDefs().keySet()) {
            map = builder.getMap(string);
            for (ConfigPayloadBuilder element : map.getElements()) {
                this.sendUserConfiguredFiles(element, sentFiles, key);
            }
        }
    }

    private static boolean isFileOrPathMap(Map.Entry<String, ConfigDefinition.LeafMapDef> entry) {
        String mapType = entry.getValue().getTypeSpec().getType();
        return "file".equals(mapType) || "path".equals(mapType);
    }

    private static boolean isFileOrPathArray(Map.Entry<String, ConfigDefinition.ArrayDef> entry) {
        String arrayType = entry.getValue().getTypeSpec().getType();
        return "file".equals(arrayType) || "path".equals(arrayType);
    }

    private void sendEntries(ConfigPayloadBuilder builder, Map<String, FileReference> sentFiles, Map<String, ? extends ConfigDefinition.DefaultValued<String>> entries) {
        for (String name : entries.keySet()) {
            ConfigPayloadBuilder fileEntry = builder.getObject(name);
            if (fileEntry.getValue() == null) {
                throw new IllegalArgumentException("Unable to send file for field '" + name + "'. Invalid config value " + fileEntry.getValue());
            }
            this.sendFileEntry(fileEntry, sentFiles);
        }
    }

    private void sendFileEntries(Collection<ConfigPayloadBuilder> builders, Map<String, FileReference> sentFiles) {
        for (ConfigPayloadBuilder builder : builders) {
            this.sendFileEntry(builder, sentFiles);
        }
    }

    private void sendFileEntry(ConfigPayloadBuilder builder, Map<String, FileReference> sentFiles) {
        String path = builder.getValue();
        FileReference reference = sentFiles.get(path);
        if (reference == null) {
            reference = this.fileRegistry.addFile(path);
            FileSender.send(reference, this.services);
            sentFiles.put(path, reference);
        }
        builder.setValue(reference.value());
    }
}

