/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.vespa.model.content.DispatchSpec;
import com.yahoo.vespa.model.search.SearchNode;
import java.util.ArrayList;
import java.util.List;

public class DispatchGroupBuilder {
    public static List<DispatchSpec.Group> createDispatchGroups(List<SearchNode> searchNodes, int numDispatchGroups) {
        if (numDispatchGroups > searchNodes.size()) {
            numDispatchGroups = searchNodes.size();
        }
        ArrayList<DispatchSpec.Group> groupsSpec = new ArrayList<DispatchSpec.Group>();
        int numNodesPerGroup = searchNodes.size() / numDispatchGroups;
        if (searchNodes.size() % numDispatchGroups != 0) {
            ++numNodesPerGroup;
        }
        int searchNodeIdx = 0;
        for (int i = 0; i < numDispatchGroups; ++i) {
            DispatchSpec.Group groupSpec = new DispatchSpec.Group();
            for (int j = 0; j < numNodesPerGroup && searchNodeIdx < searchNodes.size(); ++j) {
                groupSpec.addNode(new DispatchSpec.Node(searchNodes.get(searchNodeIdx++).getDistributionKey()));
            }
            groupsSpec.add(groupSpec);
        }
        assert (searchNodeIdx == searchNodes.size());
        return groupsSpec;
    }
}

