/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.ml;

import ai.vespa.models.evaluation.ModelsEvaluator;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import ai.vespa.rankingexpression.importer.lightgbm.LightGBMImporter;
import ai.vespa.rankingexpression.importer.onnx.OnnxImporter;
import ai.vespa.rankingexpression.importer.tensorflow.TensorFlowImporter;
import ai.vespa.rankingexpression.importer.vespa.VespaImporter;
import ai.vespa.rankingexpression.importer.xgboost.XGBoostImporter;
import com.google.common.collect.ImmutableList;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.filedistribution.fileacquirer.MockFileAcquirer;
import com.yahoo.io.IOUtils;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.model.VespaModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import org.xml.sax.SAXException;

public class ModelsEvaluatorTester {
    private static final ImmutableList<MlModelImporter> importers = ImmutableList.of((Object)new TensorFlowImporter(), (Object)new OnnxImporter(), (Object)new LightGBMImporter(), (Object)new XGBoostImporter(), (Object)new VespaImporter());
    private static final String modelEvaluationServices = "<services version=\"1.0\">  <container version=\"1.0\">    <model-evaluation/>  </container></services>";

    public static ModelsEvaluator create(String modelsPath) {
        File temporaryApplicationDir = null;
        try {
            temporaryApplicationDir = ModelsEvaluatorTester.createTemporaryApplicationDir(modelsPath);
            RankProfileList rankProfileList = ModelsEvaluatorTester.createRankProfileList(temporaryApplicationDir);
            RankProfilesConfig rankProfilesConfig = ModelsEvaluatorTester.getRankProfilesConfig(rankProfileList);
            RankingConstantsConfig rankingConstantsConfig = ModelsEvaluatorTester.getRankingConstantConfig(rankProfileList);
            RankingExpressionsConfig rankingExpressionsConfig = ModelsEvaluatorTester.getRankingExpressionsConfig(rankProfileList);
            OnnxModelsConfig onnxModelsConfig = ModelsEvaluatorTester.getOnnxModelsConfig(rankProfileList);
            FileAcquirer files = ModelsEvaluatorTester.createFileAcquirer(rankingConstantsConfig, onnxModelsConfig, temporaryApplicationDir);
            ModelsEvaluator modelsEvaluator = new ModelsEvaluator(rankProfilesConfig, rankingConstantsConfig, rankingExpressionsConfig, onnxModelsConfig, files);
            return modelsEvaluator;
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (temporaryApplicationDir != null) {
                IOUtils.recursiveDeleteDir((File)temporaryApplicationDir);
            }
        }
    }

    private static File createTemporaryApplicationDir(String modelsPath) throws IOException {
        String tmpDir = Files.exists(Path.of("target", new String[0]), new LinkOption[0]) ? "target" : "";
        File temporaryApplicationDir = Files.createTempDirectory(Path.of(tmpDir, new String[0]), "tmp_", new FileAttribute[0]).toFile();
        File modelsDir = ModelsEvaluatorTester.relativePath(temporaryApplicationDir, ApplicationPackage.MODELS_DIR.toString());
        IOUtils.copyDirectory((File)new File(modelsPath), (File)modelsDir);
        return temporaryApplicationDir;
    }

    private static RankProfileList createRankProfileList(File appDir) throws IOException, SAXException {
        ApplicationPackage app = new MockApplicationPackage.Builder().withEmptyHosts().withServices(modelEvaluationServices).withRoot(appDir).build();
        DeployState deployState = new DeployState.Builder().applicationPackage(app).modelImporters((Collection<MlModelImporter>)importers).build();
        VespaModel vespaModel = new VespaModel(deployState);
        return vespaModel.rankProfileList();
    }

    private static RankProfilesConfig getRankProfilesConfig(RankProfileList rankProfileList) {
        RankProfilesConfig.Builder builder = new RankProfilesConfig.Builder();
        rankProfileList.getConfig(builder);
        return builder.build();
    }

    private static RankingConstantsConfig getRankingConstantConfig(RankProfileList rankProfileList) {
        RankingConstantsConfig.Builder builder = new RankingConstantsConfig.Builder();
        rankProfileList.getConfig(builder);
        return builder.build();
    }

    private static RankingExpressionsConfig getRankingExpressionsConfig(RankProfileList rankProfileList) {
        RankingExpressionsConfig.Builder builder = new RankingExpressionsConfig.Builder();
        rankProfileList.getConfig(builder);
        return builder.build();
    }

    private static OnnxModelsConfig getOnnxModelsConfig(RankProfileList rankProfileList) {
        OnnxModelsConfig.Builder builder = new OnnxModelsConfig.Builder();
        rankProfileList.getConfig(builder);
        return builder.build();
    }

    private static FileAcquirer createFileAcquirer(RankingConstantsConfig constantsConfig, OnnxModelsConfig onnxModelsConfig, File appDir) {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (RankingConstantsConfig.Constant constant : constantsConfig.constant()) {
            fileMap.put(constant.fileref().value(), ModelsEvaluatorTester.relativePath(appDir, constant.fileref().value()));
        }
        for (OnnxModelsConfig.Model model : onnxModelsConfig.model()) {
            fileMap.put(model.fileref().value(), ModelsEvaluatorTester.relativePath(appDir, model.fileref().value()));
        }
        return MockFileAcquirer.returnFiles(fileMap);
    }

    private static File relativePath(File root, String subpath) {
        return new File(root.getAbsolutePath() + File.separator + subpath);
    }
}

