/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.path.Path;
import com.yahoo.searchdefinition.DistributableResource;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.ConstantTensorJsonValidator;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.NamedSchema;
import java.io.FileNotFoundException;

public class RankingConstantsValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        ApplicationPackage applicationPackage = deployState.getApplicationPackage();
        ExceptionMessageCollector exceptionMessageCollector = new ExceptionMessageCollector("Invalid constant tensor file(s):");
        for (NamedSchema sd : deployState.getSchemas()) {
            for (RankingConstant rc : sd.getSearch().rankingConstants().asMap().values()) {
                try {
                    this.validateRankingConstant(rc, applicationPackage);
                }
                catch (ConstantTensorJsonValidator.InvalidConstantTensor | FileNotFoundException ex) {
                    exceptionMessageCollector.add(ex, rc.getName(), rc.getFileName());
                }
            }
        }
        if (exceptionMessageCollector.exceptionsOccurred) {
            throw new TensorValidationFailed(exceptionMessageCollector.combinedMessage);
        }
    }

    private void validateRankingConstant(RankingConstant rankingConstant, ApplicationPackage application) throws FileNotFoundException {
        if (rankingConstant.getPathType() == DistributableResource.PathType.FILE) {
            String constantFile = rankingConstant.getFileName();
            if (application.getFileReference(Path.fromString((String)"")).getAbsolutePath().endsWith(".preprocessed") && constantFile.startsWith(".preprocessed")) {
                constantFile = constantFile.substring(".preprocessed".length());
            }
            ApplicationFile tensorApplicationFile = application.getFile(Path.fromString((String)constantFile));
            new ConstantTensorJsonValidator().validate(constantFile, rankingConstant.getTensorType(), tensorApplicationFile.createReader());
        }
    }

    static class TensorValidationFailed
    extends RuntimeException {
        TensorValidationFailed(String message) {
            super(message);
        }
    }

    private static class ExceptionMessageCollector {
        String combinedMessage;
        boolean exceptionsOccurred = false;

        ExceptionMessageCollector(String messagePrelude) {
            this.combinedMessage = messagePrelude;
        }

        public ExceptionMessageCollector add(Throwable throwable, String rcName, String rcFilename) {
            this.exceptionsOccurred = true;
            this.combinedMessage = this.combinedMessage + String.format("\nRanking constant '%s' (%s): %s", rcName, rcFilename, throwable.getMessage());
            return this;
        }
    }
}

