/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.searchdefinition.RankExpressionBody;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LargeRankExpressions {
    private final Map<String, RankExpressionBody> expressions = new HashMap<String, RankExpressionBody>();
    private final FileRegistry fileRegistry;

    public LargeRankExpressions(FileRegistry fileRegistry) {
        this.fileRegistry = fileRegistry;
    }

    public void add(RankExpressionBody expression) {
        expression.validate();
        expression.register(this.fileRegistry);
        String name = expression.getName();
        if (this.expressions.containsKey(name)) {
            throw new IllegalArgumentException("Rank expression '" + name + "' defined twice. Previous blob with " + this.expressions.get(name).getBlob().remaining() + " bytes, while current has " + expression.getBlob().remaining() + " bytes");
        }
        this.expressions.put(name, expression);
    }

    public RankExpressionBody get(String name) {
        return this.expressions.get(name);
    }

    public Map<String, RankExpressionBody> asMap() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.expressions.values().forEach(constant -> constant.sendTo(services));
    }
}

