/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.cloud.config.SentinelConfig;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.Service;

public class ConfigSentinel
extends AbstractService
implements SentinelConfig.Producer {
    private final ApplicationId applicationId;
    private final Zone zone;

    public ConfigSentinel(Host host, ApplicationId applicationId, Zone zone) {
        super(host, "sentinel");
        this.applicationId = applicationId;
        this.zone = zone;
        this.portsMeta.on(0).tag("rpc").tag("admin");
        this.portsMeta.on(1).tag("telnet").tag("interactive").tag("http").tag("state");
        this.setProp("clustertype", "hosts");
        this.setProp("clustername", "admin");
    }

    @Override
    public int getWantedPort() {
        return 19097;
    }

    @Override
    public boolean requiresWantedPort() {
        return true;
    }

    @Override
    public int getPortCount() {
        return 2;
    }

    @Override
    public String[] getPortSuffixes() {
        return new String[]{"rpc", "http"};
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(1);
    }

    @Override
    public String getServiceType() {
        return "config-sentinel";
    }

    public void getConfig(SentinelConfig.Builder builder) {
        builder.application(this.getApplicationConfig());
        for (Service s : this.getHostResource().getServices()) {
            if (s.getStartupCommand() == null) continue;
            builder.service(this.getServiceConfig(s));
        }
    }

    private SentinelConfig.Application.Builder getApplicationConfig() {
        SentinelConfig.Application.Builder builder = new SentinelConfig.Application.Builder();
        builder.tenant(this.applicationId.tenant().value());
        builder.name(this.applicationId.application().value());
        builder.environment(this.zone.environment().value());
        builder.region(this.zone.region().value());
        builder.instance(this.applicationId.instance().value());
        return builder;
    }

    private SentinelConfig.Service.Builder getServiceConfig(Service s) {
        SentinelConfig.Service.Builder serviceBuilder = new SentinelConfig.Service.Builder();
        serviceBuilder.command(s.getStartupCommand());
        serviceBuilder.name(s.getServiceName());
        serviceBuilder.id(s.getConfigId());
        serviceBuilder.affinity(this.getServiceAffinity(s));
        this.setPreShutdownCommand(serviceBuilder, s);
        return serviceBuilder;
    }

    private void setPreShutdownCommand(SentinelConfig.Service.Builder serviceBuilder, Service service) {
        if (service.getPreShutdownCommand().isPresent()) {
            serviceBuilder.preShutdownCommand(service.getPreShutdownCommand().get());
        }
    }

    private SentinelConfig.Service.Affinity.Builder getServiceAffinity(Service s) {
        SentinelConfig.Service.Affinity.Builder builder = new SentinelConfig.Service.Affinity.Builder();
        if (s.getAffinity().isPresent()) {
            builder.cpuSocket(s.getAffinity().get().cpuSocket());
        }
        return builder;
    }
}

