/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.utils.internal;

import com.google.common.reflect.TypeToken;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.model.ConfigProducer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Set<ConfigKey<?>> getAllConfigsProduced(Class<? extends ConfigProducer> producerClass, String configId) {
        TypeToken.TypeSet interfaces = TypeToken.of(producerClass).getTypes().interfaces();
        return interfaces.rawTypes().stream().filter(ReflectionUtil::isConcreteProducer).map(i -> ReflectionUtil.createConfigKeyFromInstance(i.getEnclosingClass(), configId)).collect(Collectors.toSet());
    }

    public static boolean hasRestartMethods(Class<? extends ConfigInstance> configClass) {
        try {
            configClass.getDeclaredMethod("containsFieldsFlaggedWithRestart", new Class[0]);
            configClass.getDeclaredMethod("getChangesRequiringRestart", configClass);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean containsFieldsFlaggedWithRestart(Class<? extends ConfigInstance> configClass) {
        try {
            Method m = configClass.getDeclaredMethod("containsFieldsFlaggedWithRestart", new Class[0]);
            m.setAccessible(true);
            return (Boolean)m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ChangesRequiringRestart getChangesRequiringRestart(ConfigInstance from, ConfigInstance to) {
        Class<?> clazz = from.getClass();
        if (!clazz.equals(to.getClass())) {
            throw new IllegalArgumentException(String.format("%s != %s", clazz, to.getClass()));
        }
        try {
            Method m = clazz.getDeclaredMethod("getChangesRequiringRestart", clazz);
            m.setAccessible(true);
            return (ChangesRequiringRestart)m.invoke((Object)from, to);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        ArrayList result = new ArrayList();
        for (Class<?> superClass = cls.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            result.add(superClass);
        }
        return result;
    }

    private static ConfigKey<?> createConfigKeyFromInstance(Class<?> configInstClass, String configId) {
        try {
            String defName = ConfigInstance.getDefName(configInstClass);
            String defNamespace = ConfigInstance.getDefNamespace(configInstClass);
            return new ConfigKey(defName, configId, defNamespace);
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isConcreteProducer(Class<?> producerInterface) {
        if (ReflectionUtil.isRootConfigProducerInterface(producerInterface)) {
            return false;
        }
        boolean parentIsConfigInstance = false;
        for (Class<?> ifaceParent : producerInterface.getInterfaces()) {
            if (!ReflectionUtil.isConfigInstanceProducer(ifaceParent)) continue;
            parentIsConfigInstance = true;
        }
        return ConfigInstance.Producer.class.isAssignableFrom(producerInterface) && parentIsConfigInstance && !ReflectionUtil.isConfigInstanceProducer(producerInterface);
    }

    private static boolean isConfigInstanceProducer(Class<?> clazz) {
        return clazz.getName().equals(ConfigInstance.Producer.class.getName());
    }

    private static boolean isRootConfigProducerInterface(Class<?> clazz) {
        return clazz.getCanonicalName().equals(ConfigProducer.class.getCanonicalName());
    }
}

