/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.ResourceLimits;
import java.util.logging.Level;

public class DomResourceLimitsBuilder {
    public static ResourceLimits.Builder createBuilder(ModelElement contentXml, boolean hostedVespa, boolean throwIfSpecified, DeployLogger deployLogger) {
        ResourceLimits.Builder builder = new ResourceLimits.Builder();
        ModelElement resourceLimits = contentXml.child("resource-limits");
        if (resourceLimits == null) {
            return builder;
        }
        if (hostedVespa) {
            String message = "Element '" + resourceLimits + "' is not allowed to be set";
            if (throwIfSpecified) {
                throw new IllegalArgumentException(message);
            }
            deployLogger.logApplicationPackage(Level.WARNING, message);
        }
        if (resourceLimits.child("disk") != null) {
            builder.setDiskLimit(resourceLimits.childAsDouble("disk"));
        }
        if (resourceLimits.child("memory") != null) {
            builder.setMemoryLimit(resourceLimits.childAsDouble("memory"));
        }
        return builder;
    }
}

