/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashSet;
import java.util.Set;

public class IntegerIndex2Attribute
extends Processor {
    public IntegerIndex2Attribute(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.search.allConcreteFields()) {
            if (!field.doesIndexing() || !(field.getDataType().getPrimitiveType() instanceof NumericDataType) || field.getIndex(field.getName()) != null && !field.getIndex(field.getName()).getType().equals((Object)Index.Type.VESPA)) continue;
            ScriptExpression script = field.getIndexingScript();
            HashSet<String> attributeNames = new HashSet<String>();
            new MyVisitor(attributeNames).visit((Expression)script);
            field.setIndexingScript((ScriptExpression)new MyConverter(attributeNames).convert((Expression)script));
            this.warn(this.search, field, "Changed to attribute because numerical indexes (field has type " + field.getDataType().getName() + ") is not currently supported. Index-only settings may fail. Ignore this warning for streaming search.");
        }
    }

    private static class MyConverter
    extends ExpressionConverter {
        final Set<String> attributeNames;

        public MyConverter(Set<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof IndexExpression;
        }

        protected Expression doConvert(Expression exp) {
            String indexName = ((IndexExpression)exp).getFieldName();
            if (this.attributeNames.contains(indexName)) {
                return null;
            }
            return new AttributeExpression(indexName);
        }
    }

    private static class MyVisitor
    extends ExpressionVisitor {
        final Set<String> attributeNames;

        public MyVisitor(Set<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof AttributeExpression) {
                this.attributeNames.add(((AttributeExpression)exp).getFieldName());
            }
        }
    }
}

