/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.searchdefinition.document.Case;
import java.io.Serializable;
import java.util.Objects;

public class Matching
implements Cloneable,
Serializable {
    public static final Type defaultType = Type.TEXT;
    private Type type = Type.TEXT;
    private Case casing = Case.UNCASED;
    private Algorithm algorithm = Algorithm.NORMAL;
    private boolean typeUserSet = false;
    private boolean algorithmUserSet = false;
    private int gramSize = -1;
    private Integer maxLength;
    private String exactMatchTerminator = null;

    public Matching() {
    }

    public Matching(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Case getCase() {
        return this.casing;
    }

    public void setType(Type type) {
        this.type = type;
        this.typeUserSet = true;
    }

    public void setCase(Case casing) {
        this.casing = casing;
    }

    public Integer maxLength() {
        return this.maxLength;
    }

    public Matching maxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public boolean isTypeUserSet() {
        return this.typeUserSet;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        this.algorithmUserSet = true;
    }

    public boolean isAlgorithmUserSet() {
        return this.algorithmUserSet;
    }

    public boolean isPrefix() {
        return this.algorithm == Algorithm.PREFIX;
    }

    public boolean isSubstring() {
        return this.algorithm == Algorithm.SUBSTRING;
    }

    public boolean isSuffix() {
        return this.algorithm == Algorithm.SUFFIX;
    }

    public int getGramSize() {
        return this.gramSize;
    }

    public void setGramSize(int gramSize) {
        this.gramSize = gramSize;
    }

    public void merge(Matching m) {
        if (m.isAlgorithmUserSet()) {
            this.setAlgorithm(m.getAlgorithm());
        }
        if (m.isTypeUserSet()) {
            this.setType(m.getType());
            if (m.getType() == Type.GRAM) {
                this.gramSize = m.gramSize;
            }
        }
        if (m.getExactMatchTerminator() != null) {
            this.setExactMatchTerminator(m.getExactMatchTerminator());
        }
    }

    public String getExactMatchTerminator() {
        return this.exactMatchTerminator;
    }

    public void setExactMatchTerminator(String exactMatchTerminator) {
        this.exactMatchTerminator = exactMatchTerminator;
    }

    public String toString() {
        return this.type + " matching [" + (this.type == Type.GRAM ? "gram size " + this.gramSize : "supports " + this.algorithm) + "], [exact-terminator " + this.exactMatchTerminator + "]";
    }

    public Matching clone() {
        try {
            return (Matching)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matching)) {
            return false;
        }
        Matching other = (Matching)o;
        if (!other.type.equals((Object)this.type)) {
            return false;
        }
        if (!other.algorithm.equals((Object)this.algorithm)) {
            return false;
        }
        if (this.exactMatchTerminator == null && other.exactMatchTerminator != null) {
            return false;
        }
        if (this.exactMatchTerminator != null && !this.exactMatchTerminator.equals(other.exactMatchTerminator)) {
            return false;
        }
        return this.gramSize == other.gramSize;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.algorithm, this.exactMatchTerminator, this.gramSize});
    }

    public static enum Algorithm {
        NORMAL("normal"),
        PREFIX("prefix"),
        SUBSTRING("substring"),
        SUFFIX("suffix");

        private String name;

        private Algorithm(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        TEXT("text"),
        WORD("word"),
        EXACT("exact"),
        GRAM("gram");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

