/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.Matching;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public class FieldSet {
    private final String name;
    private final Set<String> queryCommands = new LinkedHashSet<String>();
    private final Set<String> fieldNames = new TreeSet<String>();
    private final Set<ImmutableSDField> fields = new TreeSet<ImmutableSDField>(Comparator.comparing(ImmutableSDField::asField));
    private Matching matching = null;

    public FieldSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FieldSet addFieldName(String field) {
        this.fieldNames.add(field);
        return this;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public Set<ImmutableSDField> fields() {
        return this.fields;
    }

    public Set<String> queryCommands() {
        return this.queryCommands;
    }

    public void setMatching(Matching matching) {
        this.matching = matching;
    }

    public Matching getMatching() {
        return this.matching;
    }

    public String toString() {
        return "fieldset '" + this.name + "'";
    }
}

