/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class IndexFieldNames
extends Processor {
    private static final String FIELD_NAME_REGEXP = "[a-zA-Z]\\w*";

    public IndexFieldNames(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.search.allConcreteFields()) {
            if (field.getName().matches(FIELD_NAME_REGEXP) || this.legalDottedPositionField(field)) continue;
            this.fail(this.search, field, " Not a legal field name. Legal expression: [a-zA-Z]\\w*");
        }
    }

    private boolean legalDottedPositionField(SDField field) {
        return field.getName().endsWith(".position") || field.getName().endsWith(".distance");
    }
}

