/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.cluster.DomResourceLimitsBuilder;
import java.util.Optional;
import java.util.function.Consumer;

public class ClusterResourceLimits {
    private final ResourceLimits clusterControllerLimits;
    private final ResourceLimits contentNodeLimits;

    private ClusterResourceLimits(Builder builder) {
        this.clusterControllerLimits = builder.ctrlBuilder.build();
        this.contentNodeLimits = builder.nodeBuilder.build();
    }

    public ResourceLimits getClusterControllerLimits() {
        return this.clusterControllerLimits;
    }

    public ResourceLimits getContentNodeLimits() {
        return this.contentNodeLimits;
    }

    public static class Builder {
        private final boolean enableFeedBlockInDistributor;
        private final boolean hostedVespa;
        private final boolean throwIfSpecified;
        private ResourceLimits.Builder ctrlBuilder = new ResourceLimits.Builder();
        private ResourceLimits.Builder nodeBuilder = new ResourceLimits.Builder();

        public Builder(boolean enableFeedBlockInDistributor, boolean hostedVespa, boolean throwIfSpecified) {
            this.enableFeedBlockInDistributor = enableFeedBlockInDistributor;
            this.hostedVespa = hostedVespa;
            this.throwIfSpecified = throwIfSpecified;
        }

        public ClusterResourceLimits build(ModelElement clusterElem) {
            this.ctrlBuilder = this.createBuilder(clusterElem.childByPath("tuning"));
            this.nodeBuilder = this.createBuilder(clusterElem.childByPath("engine.proton"));
            this.deriveLimits();
            return new ClusterResourceLimits(this);
        }

        private ResourceLimits.Builder createBuilder(ModelElement element) {
            return element == null ? new ResourceLimits.Builder() : DomResourceLimitsBuilder.createBuilder(element, this.hostedVespa, this.throwIfSpecified);
        }

        public void setClusterControllerBuilder(ResourceLimits.Builder builder) {
            this.ctrlBuilder = builder;
        }

        public void setContentNodeBuilder(ResourceLimits.Builder builder) {
            this.nodeBuilder = builder;
        }

        public ClusterResourceLimits build() {
            this.deriveLimits();
            return new ClusterResourceLimits(this);
        }

        private void deriveLimits() {
            if (this.enableFeedBlockInDistributor) {
                this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getDiskLimit(), this.nodeBuilder.getDiskLimit(), this.ctrlBuilder::setDiskLimit);
                this.considerSettingDefaultClusterControllerLimit(this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder::setMemoryLimit);
            }
            this.deriveClusterControllerLimit(this.ctrlBuilder.getDiskLimit(), this.nodeBuilder.getDiskLimit(), this.ctrlBuilder::setDiskLimit);
            this.deriveClusterControllerLimit(this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder::setMemoryLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getDiskLimit(), this.ctrlBuilder.getDiskLimit(), this.nodeBuilder::setDiskLimit);
            this.deriveContentNodeLimit(this.nodeBuilder.getMemoryLimit(), this.ctrlBuilder.getMemoryLimit(), this.nodeBuilder::setMemoryLimit);
        }

        private void considerSettingDefaultClusterControllerLimit(Optional<Double> clusterControllerLimit, Optional<Double> contentNodeLimit, Consumer<Double> setter) {
            if (clusterControllerLimit.isEmpty() && contentNodeLimit.isEmpty()) {
                setter.accept(0.8);
            }
        }

        private void deriveClusterControllerLimit(Optional<Double> clusterControllerLimit, Optional<Double> contentNodeLimit, Consumer<Double> setter) {
            if (clusterControllerLimit.isEmpty()) {
                contentNodeLimit.ifPresent(limit -> setter.accept(Double.max(0.0, limit - 0.01)));
            }
        }

        private void deriveContentNodeLimit(Optional<Double> contentNodeLimit, Optional<Double> clusterControllerLimit, Consumer<Double> setter) {
            if (contentNodeLimit.isEmpty()) {
                clusterControllerLimit.ifPresent(limit -> setter.accept(this.calcContentNodeLimit((double)limit)));
            }
        }

        private double calcContentNodeLimit(double clusterControllerLimit) {
            return clusterControllerLimit + (1.0 - clusterControllerLimit) / 2.0;
        }
    }
}

