/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.config.model.api.Reindexing;
import com.yahoo.documentmodel.NewDocumentType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReindexingContext {
    private final Object monitor = new Object();
    private final Map<String, Set<NewDocumentType>> documentTypesPerCluster = new HashMap<String, Set<NewDocumentType>>();
    private final Reindexing reindexing;

    public ReindexingContext(Reindexing reindexing) {
        this.reindexing = Objects.requireNonNull(reindexing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentType(String clusterId, NewDocumentType type) {
        Object object = this.monitor;
        synchronized (object) {
            this.documentTypesPerCluster.computeIfAbsent(clusterId, ignored -> new HashSet()).add(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> clusterIds() {
        Object object = this.monitor;
        synchronized (object) {
            return new HashSet<String>(this.documentTypesPerCluster.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NewDocumentType> documentTypesForCluster(String clusterId) {
        Object object = this.monitor;
        synchronized (object) {
            return new HashSet<NewDocumentType>(this.documentTypesPerCluster.getOrDefault(clusterId, Set.of()));
        }
    }

    public Reindexing reindexing() {
        return this.reindexing;
    }
}

