/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.Case;
import com.yahoo.searchdefinition.document.Dictionary;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DictionaryProcessor
extends Processor {
    public DictionaryProcessor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.search.allConcreteFields()) {
            Attribute attribute;
            Dictionary dictionary = field.getDictionary();
            if (dictionary == null || (attribute = field.getAttribute()) == null) continue;
            if (attribute.getDataType().getPrimitiveType() instanceof NumericDataType) {
                if (attribute.isFastSearch()) {
                    attribute.setDictionary(dictionary);
                    continue;
                }
                this.fail(this.search, field, "You must specify 'attribute:fast-search' to allow dictionary control");
                continue;
            }
            if (attribute.getDataType().getPrimitiveType() == PrimitiveDataType.STRING) {
                attribute.setDictionary(dictionary);
                Matching matching = field.getMatching();
                if (dictionary.getType() == Dictionary.Type.HASH) {
                    if (dictionary.getMatch() != Case.CASED) {
                        this.fail(this.search, field, "hash dictionary require cased match");
                    }
                } else if (dictionary.getMatch() != Case.UNCASED) {
                    this.fail(this.search, field, "btree dictionary require uncased match");
                }
                if (dictionary.getMatch().equals((Object)matching.getCase())) continue;
                this.fail(this.search, field, "Dictionary casing '" + dictionary.getMatch() + "' does not match field match casing '" + matching.getCase() + "'");
                continue;
            }
            this.fail(this.search, field, "You can only specify 'dictionary:' for numeric or string fields");
        }
    }
}

