/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.path.Path;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.ml.OnnxModelInfo;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OnnxModel {
    private final String name;
    private PathType pathType = PathType.FILE;
    private String path = null;
    private String fileReference = "";
    private OnnxModelInfo modelInfo = null;
    private Map<String, String> inputMap = new HashMap<String, String>();
    private Map<String, String> outputMap = new HashMap<String, String>();

    public OnnxModel(String name) {
        this.name = name;
    }

    public OnnxModel(String name, String fileName) {
        this(name);
        this.path = fileName;
        this.validate();
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.path = fileName;
        this.pathType = PathType.FILE;
    }

    public void setUri(String uri) {
        throw new IllegalArgumentException("URI for ONNX models are not currently supported");
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void addInputNameMapping(String onnxName, String vespaName) {
        this.addInputNameMapping(onnxName, vespaName, true);
    }

    public void addInputNameMapping(String onnxName, String vespaName, boolean overwrite) {
        Objects.requireNonNull(onnxName, "Onnx name cannot be null");
        Objects.requireNonNull(vespaName, "Vespa name cannot be null");
        if (overwrite || !this.inputMap.containsKey(onnxName)) {
            this.inputMap.put(onnxName, vespaName);
        }
    }

    public void addOutputNameMapping(String onnxName, String vespaName) {
        this.addOutputNameMapping(onnxName, vespaName, true);
    }

    public void addOutputNameMapping(String onnxName, String vespaName, boolean overwrite) {
        Objects.requireNonNull(onnxName, "Onnx name cannot be null");
        Objects.requireNonNull(vespaName, "Vespa name cannot be null");
        if (overwrite || !this.outputMap.containsKey(onnxName)) {
            this.outputMap.put(onnxName, vespaName);
        }
    }

    public void setModelInfo(OnnxModelInfo modelInfo) {
        Objects.requireNonNull(modelInfo, "Onnx model info cannot be null");
        this.modelInfo = modelInfo;
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        FileReference reference = this.pathType == PathType.FILE ? FileSender.sendFileToServices(this.path, services) : FileSender.sendUriToServices(this.path, services);
        this.fileReference = reference.value();
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.path;
    }

    public Path getFilePath() {
        return Path.fromString((String)this.path);
    }

    public String getUri() {
        return this.path;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public Map<String, String> getInputMap() {
        return Collections.unmodifiableMap(this.inputMap);
    }

    public Map<String, String> getOutputMap() {
        return Collections.unmodifiableMap(this.outputMap);
    }

    public String getDefaultOutput() {
        return this.modelInfo != null ? this.modelInfo.getDefaultOutput() : "";
    }

    TensorType getTensorType(String onnxName, Map<String, TensorType> inputTypes) {
        return this.modelInfo != null ? this.modelInfo.getTensorType(onnxName, inputTypes) : TensorType.empty;
    }

    public void validate() {
        if (this.path == null || this.path.isEmpty()) {
            throw new IllegalArgumentException("ONNX models must have a file or uri.");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("onnx-model '").append(this.name).append(this.pathType == PathType.FILE ? "' from file '" : " from uri ").append(this.path).append("' with ref '").append(this.fileReference).append("'");
        return b.toString();
    }

    public static enum PathType {
        FILE,
        URI;

    }
}

