/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.ConfiguredDirectSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HostedSslConnectorFactory
extends ConnectorFactory {
    private static final List<String> INSECURE_WHITELISTED_PATHS = List.of("/status.html");
    private static final String DEFAULT_HOSTED_TRUSTSTORE = "/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem";
    private final boolean enforceClientAuth;
    private final boolean enforceHandshakeClientAuth;

    public static HostedSslConnectorFactory withProvidedCertificate(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, boolean enforceHandshakeClientAuth, boolean enableHttp2) {
        ConfiguredDirectSslProvider sslProvider = HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, DEFAULT_HOSTED_TRUSTSTORE, null, enforceHandshakeClientAuth);
        return new HostedSslConnectorFactory(sslProvider, false, enforceHandshakeClientAuth, enableHttp2);
    }

    public static HostedSslConnectorFactory withProvidedCertificateAndTruststore(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificates, boolean enableHttp2) {
        ConfiguredDirectSslProvider sslProvider = HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, null, tlsCaCertificates, false);
        return new HostedSslConnectorFactory(sslProvider, true, false, enableHttp2);
    }

    public static HostedSslConnectorFactory withDefaultCertificateAndTruststore(String serverName, boolean enableHttp2) {
        return new HostedSslConnectorFactory(new DefaultSslProvider(serverName), true, false, enableHttp2);
    }

    private HostedSslConnectorFactory(SslProvider sslProvider, boolean enforceClientAuth, boolean enforceHandshakeClientAuth, boolean enableHttp2) {
        super(new ConnectorFactory.Builder("tls4443", 4443).sslProvider(sslProvider).enableHttp2(enableHttp2));
        this.enforceClientAuth = enforceClientAuth;
        this.enforceHandshakeClientAuth = enforceHandshakeClientAuth;
    }

    private static ConfiguredDirectSslProvider createConfiguredDirectSslProvider(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificatesPath, String tlsCaCertificates, boolean enforceHandshakeClientAuth) {
        ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication = enforceHandshakeClientAuth ? ConnectorConfig.Ssl.ClientAuth.Enum.NEED_AUTH : ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH;
        return new ConfiguredDirectSslProvider(serverName, endpointCertificateSecrets.key(), endpointCertificateSecrets.certificate(), tlsCaCertificatesPath, tlsCaCertificates, clientAuthentication);
    }

    @Override
    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        super.getConfig(connectorBuilder);
        if (!this.enforceHandshakeClientAuth) {
            connectorBuilder.tlsClientAuthEnforcer(new ConnectorConfig.TlsClientAuthEnforcer.Builder().pathWhitelist(INSECURE_WHITELISTED_PATHS).enable(this.enforceClientAuth));
        }
        connectorBuilder.ssl.enabledProtocols(List.of("TLSv1.2"));
        HashSet<String> ciphers = new HashSet<String>(TlsContext.ALLOWED_CIPHER_SUITES);
        ciphers.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
        connectorBuilder.ssl.enabledCipherSuites(Set.copyOf(ciphers));
        connectorBuilder.proxyProtocol(new ConnectorConfig.ProxyProtocol.Builder().enabled(true).mixedMode(true)).idleTimeout((double)Duration.ofMinutes(3L).toSeconds()).maxConnectionLife((double)Duration.ofMinutes(10L).toSeconds());
    }
}

