/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.searchdefinition.document.Dictionary;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;

public class DictionaryOperation
implements FieldOperation {
    private final Dictionary.Type type;

    public DictionaryOperation(Dictionary.Type type) {
        this.type = type;
    }

    @Override
    public void apply(SDField field) {
        Dictionary prev = field.getDictionary();
        if (prev == null) {
            field.setDictionary(new Dictionary(this.type));
        } else if (prev.getType() == Dictionary.Type.BTREE && this.type == Dictionary.Type.HASH || prev.getType() == Dictionary.Type.HASH && this.type == Dictionary.Type.BTREE) {
            field.setDictionary(new Dictionary(Dictionary.Type.BTREE_AND_HASH));
        } else if (prev.getType() != this.type) {
            throw new IllegalArgumentException("Can not combine previous dictionary setting " + prev.getType() + " with current " + this.type);
        }
    }
}

