/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.util.Optional;

public class ConnectorFactory
extends SimpleComponent
implements ConnectorConfig.Producer {
    private final String name;
    private final int listenPort;
    private final SslProvider sslProviderComponent;
    private volatile ComponentId defaultRequestFilterChain;
    private volatile ComponentId defaultResponseFilterChain;

    protected ConnectorFactory(Builder builder) {
        super(new ComponentModel(new BundleInstantiationSpecification(new ComponentId(builder.name), ComponentSpecification.fromString((String)"com.yahoo.jdisc.http.server.jetty.ConnectorFactory"), ComponentSpecification.fromString((String)"jdisc_http_service"))));
        this.name = builder.name;
        this.listenPort = builder.listenPort;
        this.sslProviderComponent = builder.sslProvider != null ? builder.sslProvider : new DefaultSslProvider(this.name);
        this.defaultRequestFilterChain = builder.defaultRequestFilterChain;
        this.defaultResponseFilterChain = builder.defaultResponseFilterChain;
        this.addChild(this.sslProviderComponent);
        this.inject(this.sslProviderComponent);
    }

    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        connectorBuilder.listenPort(this.listenPort);
        connectorBuilder.name(this.name);
        this.sslProviderComponent.amendConnectorConfig(connectorBuilder);
    }

    public String getName() {
        return this.name;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public Optional<ComponentId> getDefaultRequestFilterChain() {
        return Optional.ofNullable(this.defaultRequestFilterChain);
    }

    public Optional<ComponentId> getDefaultResponseFilterChain() {
        return Optional.ofNullable(this.defaultResponseFilterChain);
    }

    public void setDefaultRequestFilterChain(ComponentId filterChain) {
        this.defaultRequestFilterChain = filterChain;
    }

    public void setDefaultResponseFilterChain(ComponentId filterChain) {
        this.defaultResponseFilterChain = filterChain;
    }

    public static class Builder {
        private final String name;
        private final int listenPort;
        private SslProvider sslProvider;
        private ComponentId defaultRequestFilterChain;
        private ComponentId defaultResponseFilterChain;

        public Builder(String name, int listenPort) {
            this.name = name;
            this.listenPort = listenPort;
        }

        public Builder sslProvider(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder defaultRequestFilterChain(ComponentId filterChain) {
            this.defaultRequestFilterChain = filterChain;
            return this;
        }

        public Builder defaultResponseFilterChain(ComponentId filterChain) {
            this.defaultResponseFilterChain = filterChain;
            return this;
        }

        public ConnectorFactory build() {
            return new ConnectorFactory(this);
        }
    }
}

