/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class StructFieldAttributeChangeValidator {
    private final ClusterSpec.Id id;
    private final NewDocumentType currentDocType;
    private final AttributeFields currentAttributes;
    private final NewDocumentType nextDocType;
    private final AttributeFields nextAttributes;

    public StructFieldAttributeChangeValidator(ClusterSpec.Id id, NewDocumentType currentDocType, AttributeFields currentAttributes, NewDocumentType nextDocType, AttributeFields nextAttributes) {
        this.id = id;
        this.currentDocType = currentDocType;
        this.currentAttributes = currentAttributes;
        this.nextDocType = nextDocType;
        this.nextAttributes = nextAttributes;
    }

    public List<VespaConfigChangeAction> validate() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (Field currentField : this.currentDocType.getAllFields()) {
            Field nextField = this.nextDocType.getField(currentField.getName());
            if (nextField == null) continue;
            result.addAll(this.validateAddAttributeAspect(new Context(currentField, this.currentAttributes), new Context(nextField, this.nextAttributes)));
        }
        return result;
    }

    private List<VespaConfigChangeAction> validateAddAttributeAspect(Context current, Context next) {
        return next.structFieldAttributes.stream().filter(nextAttr -> current.hasFieldForStructFieldAttribute((Attribute)nextAttr) && !current.hasStructFieldAttribute((Attribute)nextAttr)).map(nextAttr -> new VespaRestartAction(this.id, new ChangeMessageBuilder(nextAttr.getName()).addChange("add attribute aspect").build())).collect(Collectors.toList());
    }

    private static class Context {
        public Field field;
        public Collection<Attribute> structFieldAttributes;

        public Context(Field field, AttributeFields attributes) {
            this.field = field;
            this.structFieldAttributes = attributes.structFieldAttributes(field.getName());
        }

        public DataType dataType() {
            return this.field.getDataType();
        }

        public boolean hasStructFieldAttribute(Attribute structFieldAttribute) {
            return this.structFieldAttributes.stream().anyMatch(attr -> attr.getName().equals(structFieldAttribute.getName()));
        }

        public boolean hasFieldForStructFieldAttribute(Attribute structFieldAttribute) {
            String subFieldName;
            StringTokenizer fieldNames = new StringTokenizer(structFieldAttribute.getName(), ".");
            if (!fieldNames.nextToken().equals(this.field.getName())) {
                return false;
            }
            if (Context.isArrayOfStructType(this.dataType())) {
                StructDataType nestedType = (StructDataType)((ArrayDataType)this.dataType()).getNestedType();
                if (Context.structTypeContainsLastFieldNameComponent(nestedType, fieldNames)) {
                    return true;
                }
            } else if (Context.isMapOfStructType(this.dataType())) {
                MapDataType mapType = (MapDataType)this.dataType();
                StructDataType valueType = (StructDataType)mapType.getValueType();
                String subFieldName2 = fieldNames.nextToken();
                if (subFieldName2.equals("key") && !fieldNames.hasMoreTokens()) {
                    return true;
                }
                if (subFieldName2.equals("value") && Context.structTypeContainsLastFieldNameComponent(valueType, fieldNames)) {
                    return true;
                }
            } else if (Context.isMapOfPrimitiveType(this.dataType()) && ((subFieldName = fieldNames.nextToken()).equals("key") || subFieldName.equals("value")) && !fieldNames.hasMoreTokens()) {
                return true;
            }
            return false;
        }

        private static boolean isArrayOfStructType(DataType type) {
            if (type instanceof ArrayDataType) {
                ArrayDataType arrayType = (ArrayDataType)type;
                return Context.isStructType(arrayType.getNestedType());
            }
            return false;
        }

        private static boolean isMapOfStructType(DataType type) {
            if (type instanceof MapDataType) {
                MapDataType mapType = (MapDataType)type;
                return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && Context.isStructType(mapType.getValueType());
            }
            return false;
        }

        public static boolean isMapOfPrimitiveType(DataType type) {
            if (type instanceof MapDataType) {
                MapDataType mapType = (MapDataType)type;
                return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isPrimitiveType(mapType.getValueType());
            }
            return false;
        }

        private static boolean isStructType(DataType type) {
            return type instanceof StructDataType;
        }

        private static boolean structTypeContainsLastFieldNameComponent(StructDataType structType, StringTokenizer fieldNames) {
            return structType.getField(fieldNames.nextToken()) != null && !fieldNames.hasMoreTokens();
        }
    }
}

