/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostPorts;
import com.yahoo.vespa.model.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class HostResource
implements Comparable<HostResource> {
    private final HostSpec spec;
    private final HostPorts hostPorts;
    private final Host host;
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();

    public HostResource(Host host) {
        this(host, new HostSpec(host.getHostname(), List.of(), Optional.empty()));
    }

    public HostResource(Host host, HostSpec spec) {
        this.host = host;
        this.spec = spec;
        this.hostPorts = new HostPorts(host.getHostname());
    }

    public Host getHost() {
        return this.host;
    }

    public HostPorts ports() {
        return this.hostPorts;
    }

    public HostSpec spec() {
        return this.spec.withPorts(this.hostPorts.networkPorts());
    }

    List<Integer> allocateService(DeployLogger deployLogger, AbstractService service, int wantedPort) {
        this.ports().useLogger(deployLogger);
        List<Integer> ports = this.hostPorts.allocatePorts(service, wantedPort);
        if (this.getService(service.getServiceName()) != null) {
            throw new IllegalStateException("There is already a service with name '" + service.getServiceName() + "' registered on " + this + ". Most likely a programming error - all service classes must have unique names, even in different packages!");
        }
        this.services.put(service.getServiceName(), service);
        return ports;
    }

    public Service getService(String sentinelName) {
        return this.services.get(sentinelName);
    }

    public List<Service> getServices() {
        return new ArrayList<Service>(this.services.values());
    }

    public HostInfo getHostInfo() {
        return new HostInfo(this.getHostname(), (Collection)this.services.values().stream().map(Service::getServiceInfo).collect(Collectors.toSet()));
    }

    public NodeResources realResources() {
        return this.spec.realResources();
    }

    public NodeResources advertisedResources() {
        return this.spec.advertisedResources();
    }

    public String toString() {
        return "host '" + this.host.getHostname() + "'";
    }

    public String getHostname() {
        return this.host.getHostname();
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostResource)) {
            return false;
        }
        return ((HostResource)other).host.equals(this.host);
    }

    @Override
    public int compareTo(HostResource other) {
        return this.host.compareTo(other.host);
    }

    public int comparePrimarilyByIndexTo(HostResource other) {
        if (this.spec.membership().isPresent() && other.spec.membership().isPresent()) {
            return Integer.compare(((ClusterMembership)this.spec.membership().get()).index(), ((ClusterMembership)other.spec.membership().get()).index());
        }
        return this.getHostname().compareTo(other.getHostname());
    }
}

