/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AttributesImplicitWord
extends Processor {
    public AttributesImplicitWord(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (ImmutableSDField immutableSDField : this.search.allConcreteFields()) {
            this.processFieldRecursive(immutableSDField);
        }
    }

    private void processFieldRecursive(ImmutableSDField field) {
        this.processField(field);
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            this.processFieldRecursive(immutableSDField);
        }
    }

    private void processField(ImmutableSDField field) {
        if (this.fieldImplicitlyWordMatch(field)) {
            field.getMatching().setType(Matching.Type.WORD);
        }
    }

    private boolean fieldImplicitlyWordMatch(ImmutableSDField field) {
        PrimitiveDataType dt = field.getDataType().getPrimitiveType();
        if (dt != null && dt instanceof NumericDataType) {
            return false;
        }
        return !field.hasIndex() && !field.getAttributes().isEmpty() && field.getIndices().isEmpty() && !field.getMatching().isTypeUserSet();
    }
}

