/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.document.DocumenttypesConfig;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.io.IOUtils;
import com.yahoo.protect.Validator;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.ImportedFields;
import com.yahoo.searchdefinition.derived.IndexInfo;
import com.yahoo.searchdefinition.derived.IndexSchema;
import com.yahoo.searchdefinition.derived.IndexingScript;
import com.yahoo.searchdefinition.derived.Juniperrc;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.searchdefinition.derived.Summaries;
import com.yahoo.searchdefinition.derived.SummaryMap;
import com.yahoo.searchdefinition.derived.VsmFields;
import com.yahoo.searchdefinition.derived.VsmSummary;
import com.yahoo.searchdefinition.derived.validation.Validation;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class DerivedConfiguration {
    private final Search search;
    private Summaries summaries;
    private SummaryMap summaryMap;
    private Juniperrc juniperrc;
    private AttributeFields attributeFields;
    private RankProfileList rankProfileList;
    private IndexingScript indexingScript;
    private IndexInfo indexInfo;
    private VsmFields streamingFields;
    private VsmSummary streamingSummary;
    private IndexSchema indexSchema;
    private ImportedFields importedFields;
    private final QueryProfileRegistry queryProfiles;

    DerivedConfiguration(Search search, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels) {
        this(search, (DeployLogger)new BaseDeployLogger(), new TestProperties(), rankProfileRegistry, queryProfiles, importedModels);
    }

    public DerivedConfiguration(Search search, DeployLogger deployLogger, ModelContext.Properties deployProperties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels) {
        Validator.ensureNotNull((String)"Search definition", (Object)search);
        this.search = search;
        this.queryProfiles = queryProfiles;
        if (!search.isDocumentsOnly()) {
            this.streamingFields = new VsmFields(search);
            this.streamingSummary = new VsmSummary(search);
        }
        if (!search.isDocumentsOnly()) {
            this.attributeFields = new AttributeFields(search);
            this.summaries = new Summaries(search, deployLogger);
            this.summaryMap = new SummaryMap(search);
            this.juniperrc = new Juniperrc(search);
            this.rankProfileList = new RankProfileList(search, search.rankingConstants(), this.attributeFields, rankProfileRegistry, queryProfiles, importedModels, deployProperties);
            this.indexingScript = new IndexingScript(search);
            this.indexInfo = new IndexInfo(search);
            this.indexSchema = new IndexSchema(search);
            this.importedFields = new ImportedFields(search);
        }
        Validation.validate(this, search);
    }

    public void export(String toDirectory) throws IOException {
        if (!this.search.isDocumentsOnly()) {
            this.summaries.export(toDirectory);
            this.summaryMap.export(toDirectory);
            this.juniperrc.export(toDirectory);
            this.attributeFields.export(toDirectory);
            this.streamingFields.export(toDirectory);
            this.streamingSummary.export(toDirectory);
            this.indexSchema.export(toDirectory);
            this.rankProfileList.export(toDirectory);
            this.indexingScript.export(toDirectory);
            this.indexInfo.export(toDirectory);
            this.importedFields.export(toDirectory);
        }
    }

    public static void exportDocuments(DocumentmanagerConfig.Builder documentManagerCfg, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new DocumentmanagerConfig(documentManagerCfg), toDirectory + "/documentmanager.cfg");
    }

    public static void exportDocuments(DocumenttypesConfig.Builder documentTypesCfg, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new DocumenttypesConfig(documentTypesCfg), toDirectory + "/documenttypes.cfg");
    }

    public static void exportQueryProfiles(QueryProfileRegistry queryProfileRegistry, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new QueryProfiles(queryProfileRegistry, (level, message) -> {}).getConfig(), toDirectory + "/query-profiles.cfg");
    }

    private static void exportCfg(ConfigInstance instance, String fileName) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = IOUtils.createWriter((String)fileName, (boolean)false);
            if (writer != null) {
                writer.write(instance.toString());
                writer.write("\n");
            }
        }
        finally {
            if (writer != null) {
                IOUtils.closeWriter((Writer)writer);
            }
        }
    }

    public Summaries getSummaries() {
        return this.summaries;
    }

    public AttributeFields getAttributeFields() {
        return this.attributeFields;
    }

    public IndexingScript getIndexingScript() {
        return this.indexingScript;
    }

    public IndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public void setIndexingScript(IndexingScript script) {
        this.indexingScript = script;
    }

    public Search getSearch() {
        return this.search;
    }

    public RankProfileList getRankProfileList() {
        return this.rankProfileList;
    }

    public VsmSummary getVsmSummary() {
        return this.streamingSummary;
    }

    public VsmFields getVsmFields() {
        return this.streamingFields;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public Juniperrc getJuniperrc() {
        return this.juniperrc;
    }

    public SummaryMap getSummaryMap() {
        return this.summaryMap;
    }

    public ImportedFields getImportedFields() {
        return this.importedFields;
    }

    public QueryProfileRegistry getQueryProfiles() {
        return this.queryProfiles;
    }
}

