/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.Collection;
import java.util.Collections;

public class ContainerDocumentApi
implements FeederConfig.Producer {
    public static final String vespaClientBundleSpecification = "vespaclient-container-plugin";
    private final Options options;

    public ContainerDocumentApi(ContainerCluster cluster, Options options) {
        this.options = options;
        this.setupHandlers(cluster);
    }

    private void setupHandlers(ContainerCluster cluster) {
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.document.restapi.resource.RestApi", "document/v1/*"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", "reserved-for-internal-use/feedapi"));
    }

    private Handler newVespaClientHandler(String componentId, String bindingSuffix) {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)componentId, null, (String)vespaClientBundleSpecification), ""));
        for (String rootBinding : this.options.bindings) {
            handler.addServerBindings(rootBinding + bindingSuffix, rootBinding + bindingSuffix + "/");
        }
        return handler;
    }

    public void getConfig(FeederConfig.Builder builder) {
        if (this.options.abortondocumenterror != null) {
            builder.abortondocumenterror(this.options.abortondocumenterror.booleanValue());
        }
        if (this.options.route != null) {
            builder.route(this.options.route);
        }
        if (this.options.maxpendingdocs != null) {
            builder.maxpendingdocs(this.options.maxpendingdocs.intValue());
        }
        if (this.options.maxpendingbytes != null) {
            builder.maxpendingbytes(this.options.maxpendingbytes.intValue());
        }
        if (this.options.retryenabled != null) {
            builder.retryenabled(this.options.retryenabled.booleanValue());
        }
        if (this.options.retrydelay != null) {
            builder.retrydelay(this.options.retrydelay.doubleValue());
        }
        if (this.options.timeout != null) {
            builder.timeout(this.options.timeout.doubleValue());
        }
        if (this.options.tracelevel != null) {
            builder.tracelevel(this.options.tracelevel.intValue());
        }
        if (this.options.mbusport != null) {
            builder.mbusport(this.options.mbusport.intValue());
        }
        if (this.options.docprocChain != null) {
            builder.docprocchain(this.options.docprocChain);
        }
    }

    public static final class Options {
        private final Collection<String> bindings;
        private final Boolean abortondocumenterror;
        private final String route;
        private final Integer maxpendingdocs;
        private final Integer maxpendingbytes;
        private final Boolean retryenabled;
        private final Double retrydelay;
        private final Double timeout;
        private final Integer tracelevel;
        private final Integer mbusport;
        private final String docprocChain;

        public Options(Collection<String> bindings, Boolean abortondocumenterror, String route, Integer maxpendingdocs, Integer maxpendingbytes, Boolean retryenabled, Double retrydelay, Double timeout, Integer tracelevel, Integer mbusport, String docprocChain) {
            this.bindings = Collections.unmodifiableCollection(bindings);
            this.abortondocumenterror = abortondocumenterror;
            this.route = route;
            this.maxpendingdocs = maxpendingdocs;
            this.maxpendingbytes = maxpendingbytes;
            this.retryenabled = retryenabled;
            this.retrydelay = retrydelay;
            this.timeout = timeout;
            this.tracelevel = tracelevel;
            this.mbusport = mbusport;
            this.docprocChain = docprocChain;
        }
    }
}

