/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Optional;
import java.util.logging.Level;

public class SummaryDiskAccessValidator
extends Processor {
    public SummaryDiskAccessValidator(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        if (documentsOnly) {
            return;
        }
        for (DocumentSummary summary : this.search.getSummaries().values()) {
            for (SummaryField summaryField : summary.getSummaryFields()) {
                for (SummaryField.Source source : summaryField.getSources()) {
                    ImmutableSDField field = this.search.getField(source.getName());
                    if (field == null) {
                        field = this.findFieldProducingSummaryField(source.getName(), this.search).orElse(null);
                    }
                    if (field == null && !source.getName().equals("documentid")) {
                        throw new IllegalArgumentException(summaryField + " in " + summary + " references " + source + ", but this field does not exist");
                    }
                    if (this.isInMemory(field) || summary.isFromDisk()) continue;
                    this.deployLogger.log(Level.WARNING, summaryField + " in " + summary + " references " + source + ", which is not an attribute: Using this summary will cause disk accesses. Set 'from-disk' on this summary class to silence this warning.");
                }
            }
        }
    }

    private boolean isInMemory(ImmutableSDField field) {
        if (field == null) {
            return false;
        }
        return field.doesAttributing();
    }

    private Optional<ImmutableSDField> findFieldProducingSummaryField(String name, Search search) {
        return search.allFields().filter(field -> field.getSummaryFields().get(name) != null).findAny();
    }
}

