/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.logging.FileConnectionLog;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.ConnectionLogComponent;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import org.w3c.dom.Element;

public class ConfigServerContainerModelBuilder
extends ContainerModelBuilder {
    private final CloudConfigOptions options;

    public ConfigServerContainerModelBuilder(CloudConfigOptions options) {
        super(true, ContainerModelBuilder.Networking.enable);
        this.options = options;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        ConfigserverCluster cluster = new ConfigserverCluster(modelContext.getParentProducer(), "configserver", this.options);
        super.doBuild(model, spec, modelContext.withParent(cluster));
        cluster.setContainerCluster(model.getCluster());
    }

    @Override
    protected void addStatusHandlers(ApplicationContainerCluster cluster, boolean isHostedVespa) {
        super.addStatusHandlers(cluster, this.isHosted());
    }

    @Override
    protected void addAccessLogs(DeployState deployState, ApplicationContainerCluster cluster, Element spec) {
        if (this.isHosted()) {
            cluster.addComponent(new AccessLogComponent(cluster, AccessLogComponent.AccessLogType.jsonAccessLog, AccessLogComponent.CompressionType.ZSTD, "logs/vespa/configserver/access-json.log.%Y%m%d%H%M%S", null, true, true, "access-json.log"));
            cluster.addComponent(new ConnectionLogComponent(cluster, FileConnectionLog.class, "configserver"));
        } else {
            super.addAccessLogs(deployState, cluster, spec);
        }
    }

    @Override
    protected void addHttp(DeployState deployState, Element spec, ApplicationContainerCluster cluster, ConfigModelContext context) {
        super.addHttp(deployState, spec, cluster, context);
        if (this.isHosted()) {
            cluster.getHttp().getHttpServer().get().enableConnectionLog(true);
        }
    }

    private boolean isHosted() {
        return this.options.hostedVespa().orElse(Boolean.FALSE);
    }
}

