/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.Map;

public class MakeAliases
extends Processor {
    public MakeAliases(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        ArrayList<String> usedAliases = new ArrayList<String>();
        for (SDField field : this.search.allConcreteFields()) {
            for (Map.Entry<String, String> e : field.getAliasToName().entrySet()) {
                String alias = e.getKey();
                String name = e.getValue();
                String errMsg = "For search '" + this.search.getName() + "': alias '" + alias + "' ";
                if (validate && this.search.existsIndex(alias)) {
                    throw new IllegalArgumentException(errMsg + "is illegal since it is the name of an index.");
                }
                if (validate && this.search.getAttribute(alias) != null) {
                    throw new IllegalArgumentException(errMsg + "is illegal since it is the name of an attribute.");
                }
                if (validate && usedAliases.contains(alias)) {
                    throw new IllegalArgumentException(errMsg + "specified more than once.");
                }
                usedAliases.add(alias);
                Index index = field.getIndex(name);
                Attribute attribute = field.getAttributes().get(name);
                if (index != null) {
                    index.addAlias(alias);
                    continue;
                }
                if (attribute != null && !field.doesIndexing()) {
                    attribute.getAliases().add(alias);
                    continue;
                }
                index = new Index(name);
                index.addAlias(alias);
                field.addIndex(index);
            }
        }
    }
}

