/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.container.QrConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ContainerRestartValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, ValidationOverrides ignored, Instant now) {
        ArrayList<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();
        for (ContainerCluster containerCluster : nextModel.getContainerClusters().values()) {
            actions.addAll(containerCluster.getContainers().stream().filter(container -> ContainerRestartValidator.isExistingContainer(container, currentModel)).filter(container -> ContainerRestartValidator.shouldContainerRestartOnDeploy(container, nextModel)).map(container -> ContainerRestartValidator.createConfigChangeAction(cluster.id(), container)).collect(Collectors.toList()));
        }
        return actions;
    }

    private static ConfigChangeAction createConfigChangeAction(ClusterSpec.Id id, Container container) {
        return new VespaRestartAction(id, ContainerRestartValidator.createMessage(container), container.getServiceInfo(), true);
    }

    private static String createMessage(Container container) {
        return String.format("Container '%s' is configured to always restart on deploy.", container.getConfigId());
    }

    private static boolean shouldContainerRestartOnDeploy(Container container, VespaModel nextModel) {
        QrConfig config = nextModel.getConfig(QrConfig.class, container.getConfigId());
        return config.restartOnDeploy();
    }

    private static boolean isExistingContainer(Container container, VespaModel currentModel) {
        return currentModel.getService(container.getConfigId()).isPresent();
    }
}

