/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.documentapi.DocumentAccessProvider;
import com.yahoo.container.di.config.PlatformBundlesConfig;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.content.reindexing.ReindexingConfig;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.admin.clustercontroller.ReindexingContext;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import com.yahoo.vespa.model.container.xml.PlatformBundles;
import java.util.Set;
import java.util.TreeSet;

@RestartConfigs(value={FleetcontrollerConfig.class, ZookeeperServerConfig.class})
public class ClusterControllerContainer
extends Container
implements PlatformBundlesConfig.Producer,
ZookeeperServerConfig.Producer,
ReindexingConfig.Producer {
    private static final ComponentSpecification CLUSTERCONTROLLER_BUNDLE = new ComponentSpecification("clustercontroller-apps");
    private static final ComponentSpecification ZOOKEEPER_SERVER_BUNDLE = new ComponentSpecification("zookeeper-server");
    private static final ComponentSpecification REINDEXING_CONTROLLER_BUNDLE = new ComponentSpecification("clustercontroller-reindexer");
    private final Set<String> bundles = new TreeSet<String>();

    public ClusterControllerContainer(AbstractConfigProducer<?> parent, int index, boolean runStandaloneZooKeeper, DeployState deployState) {
        super(parent, deployState.featureFlags(), "" + index, index, deployState.isHosted());
        this.addHandler("clustercontroller-status", "com.yahoo.vespa.clustercontroller.apps.clustercontroller.StatusHandler", "/clustercontroller-status/*", CLUSTERCONTROLLER_BUNDLE);
        this.addHandler("clustercontroller-state-restapi-v2", "com.yahoo.vespa.clustercontroller.apps.clustercontroller.StateRestApiV2Handler", "/cluster/v2/*", CLUSTERCONTROLLER_BUNDLE);
        this.addComponent(new AccessLogComponent(AccessLogComponent.AccessLogType.jsonAccessLog, "controller", deployState.isHosted()));
        this.addFileBundle("clustercontroller-apps");
        this.addFileBundle("clustercontroller-core");
        this.addFileBundle("clustercontroller-utils");
        this.addFileBundle("zookeeper-server");
        this.configureReindexing();
        this.configureZooKeeperServer(runStandaloneZooKeeper, deployState.featureFlags().reconfigurableZookeeperServer());
    }

    @Override
    public int getWantedPort() {
        return 19050;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.index() == 0;
    }

    @Override
    public ContainerServiceType myServiceType() {
        return ContainerServiceType.CLUSTERCONTROLLER_CONTAINER;
    }

    private void configureZooKeeperServer(boolean runStandaloneZooKeeper, boolean reconfigurable) {
        if (reconfigurable) {
            ContainerModelBuilder.addReconfigurableZooKeeperServerComponents(this);
        } else {
            this.addComponent("clustercontroller-zookeeper-server", runStandaloneZooKeeper ? "com.yahoo.vespa.zookeeper.VespaZooKeeperServerImpl" : "com.yahoo.vespa.zookeeper.DummyVespaZooKeeperServer", ZOOKEEPER_SERVER_BUNDLE);
        }
    }

    private void addHandler(Handler<?> h, String path) {
        h.addServerBindings(SystemBindingPattern.fromHttpPath(path));
        super.addHandler(h);
    }

    private void addFileBundle(String bundleName) {
        this.bundles.add(PlatformBundles.absoluteBundlePath(bundleName).toString());
    }

    private ComponentModel createComponentModel(String id, String className, ComponentSpecification bundle) {
        return new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification(id), new ComponentSpecification(className), bundle));
    }

    private void addComponent(String id, String className, ComponentSpecification bundle) {
        this.addComponent(new Component(this.createComponentModel(id, className, bundle)));
    }

    private void addHandler(String id, String className, String path, ComponentSpecification bundle) {
        this.addHandler(new Handler(this.createComponentModel(id, className, bundle)), path);
    }

    private ReindexingContext reindexingContext() {
        return ((ClusterControllerContainerCluster)this.parent).reindexingContext();
    }

    private void configureReindexing() {
        this.addFileBundle(REINDEXING_CONTROLLER_BUNDLE.getName());
        this.addComponent(new SimpleComponent(DocumentAccessProvider.class.getName()));
        this.addComponent("reindexing-maintainer", "ai.vespa.reindexing.ReindexingMaintainer", REINDEXING_CONTROLLER_BUNDLE);
        this.addHandler("reindexing-status", "ai.vespa.reindexing.http.ReindexingV1ApiHandler", "/reindexing/v1/*", REINDEXING_CONTROLLER_BUNDLE);
    }

    public void getConfig(PlatformBundlesConfig.Builder builder) {
        this.bundles.forEach(arg_0 -> ((PlatformBundlesConfig.Builder)builder).bundlePaths(arg_0));
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }

    public void getConfig(ReindexingConfig.Builder builder) {
        ReindexingContext ctx = this.reindexingContext();
        if (!ctx.reindexing().enabled()) {
            builder.enabled(false);
            return;
        }
        builder.enabled(ctx.reindexing().enabled());
        builder.windowSizeIncrement(ctx.windowSizeIncrement());
        for (String clusterId : ctx.clusterIds()) {
            ReindexingConfig.Clusters.Builder clusterBuilder = new ReindexingConfig.Clusters.Builder();
            for (NewDocumentType type : ctx.documentTypesForCluster(clusterId)) {
                String typeName = type.getFullName().getName();
                ctx.reindexing().status(clusterId, typeName).ifPresent(status -> clusterBuilder.documentTypes(typeName, new ReindexingConfig.Clusters.DocumentTypes.Builder().readyAtMillis(status.ready().toEpochMilli())));
            }
            builder.clusters(clusterId, clusterBuilder);
        }
    }
}

