/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import ai.vespa.models.evaluation.ModelsEvaluator;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import java.util.List;
import java.util.Objects;

public class ContainerModelEvaluation
implements RankProfilesConfig.Producer,
RankingConstantsConfig.Producer {
    private static final String BUNDLE_NAME = "model-evaluation";
    private static final String EVALUATOR_NAME = ModelsEvaluator.class.getName();
    private static final String REST_HANDLER_NAME = "ai.vespa.models.handler.ModelsEvaluationHandler";
    private static final String REST_BINDING = "model-evaluation/v1";
    private final RankProfileList rankProfileList;

    public ContainerModelEvaluation(ApplicationContainerCluster cluster, RankProfileList rankProfileList) {
        this.rankProfileList = Objects.requireNonNull(rankProfileList, "rankProfileList cannot be null");
        cluster.addSimpleComponent(EVALUATOR_NAME, null, BUNDLE_NAME);
        cluster.addComponent(ContainerModelEvaluation.getHandler());
    }

    public void prepare(List<ApplicationContainer> containers) {
        this.rankProfileList.sendConstantsTo(containers);
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        this.rankProfileList.getConfig(builder);
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        this.rankProfileList.getConfig(builder);
    }

    public static Handler<?> getHandler() {
        Handler handler = new Handler(new ComponentModel(REST_HANDLER_NAME, null, BUNDLE_NAME));
        handler.addServerBindings("http://*/model-evaluation/v1", "https://*/model-evaluation/v1", "http://*/model-evaluation/v1/*", "https://*/model-evaluation/v1/*");
        return handler;
    }
}

