/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.FunctionReferenceContext;
import com.yahoo.searchlib.rankingexpression.rule.NameNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MapEvaluationTypeContext
extends FunctionReferenceContext
implements TypeContext<Reference> {
    private final Map<Reference, TensorType> featureTypes = new HashMap<Reference, TensorType>();
    private final Map<Reference, TensorType> resolvedTypes = new HashMap<Reference, TensorType>();
    private final Deque<Reference> currentResolutionCallStack;

    MapEvaluationTypeContext(Collection<ExpressionFunction> functions) {
        super(functions);
        this.currentResolutionCallStack = new ArrayDeque<Reference>();
    }

    private MapEvaluationTypeContext(Map<String, ExpressionFunction> functions, Map<String, String> bindings, Map<Reference, TensorType> featureTypes, Deque<Reference> currentResolutionCallStack) {
        super(functions, bindings);
        this.featureTypes.putAll(featureTypes);
        this.currentResolutionCallStack = currentResolutionCallStack;
    }

    public void setType(Reference reference, TensorType type) {
        this.featureTypes.put(reference, type);
    }

    public TensorType getType(String reference) {
        throw new UnsupportedOperationException("Not able to parse gereral references from string form");
    }

    public void forgetResolvedTypes() {
        this.resolvedTypes.clear();
    }

    public TensorType getType(Reference reference) {
        TensorType resolvedType = this.resolvedTypes.get(reference);
        if (resolvedType != null) {
            return resolvedType;
        }
        resolvedType = this.resolveType(reference);
        if (resolvedType == null) {
            return this.defaultTypeOf(reference);
        }
        this.resolvedTypes.put(reference, resolvedType);
        return resolvedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TensorType resolveType(Reference reference) {
        if (this.currentResolutionCallStack.contains(reference)) {
            throw new IllegalArgumentException("Invocation loop: " + this.currentResolutionCallStack.stream().map(Reference::toString).collect(Collectors.joining(" -> ")) + " -> " + reference);
        }
        Optional<String> binding = this.boundIdentifier(reference);
        if (binding.isPresent()) {
            try {
                return new RankingExpression(binding.get()).type((TypeContext)this);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            this.currentResolutionCallStack.addLast(reference);
            if (FeatureNames.isSimpleFeature(reference)) {
                String argument = (String)reference.simpleArgument().get();
                reference = Reference.simple((String)reference.name(), (String)this.bindings.getOrDefault(argument, argument));
                TensorType tensorType = this.featureTypes.get(reference);
                return tensorType;
            }
            Optional<ExpressionFunction> function = this.functionInvocation(reference);
            if (function.isPresent()) {
                TensorType tensorType = function.get().getBody().type((TypeContext)this.withBindings((Map)this.bind(function.get().arguments(), reference.arguments())));
                return tensorType;
            }
            Optional<TensorType> featureTensorType = this.tensorFeatureType(reference);
            if (featureTensorType.isPresent()) {
                TensorType tensorType = featureTensorType.get();
                return tensorType;
            }
            TensorType tensorType = TensorType.empty;
            return tensorType;
        }
        finally {
            this.currentResolutionCallStack.removeLast();
        }
    }

    public TensorType defaultTypeOf(Reference reference) {
        if (!FeatureNames.isSimpleFeature(reference)) {
            throw new IllegalArgumentException("This can only be called for simple references, not " + reference);
        }
        if (reference.name().equals("query")) {
            return TensorType.empty;
        }
        return null;
    }

    private Optional<String> boundIdentifier(Reference reference) {
        if (!reference.arguments().isEmpty()) {
            return Optional.empty();
        }
        if (reference.output() != null) {
            return Optional.empty();
        }
        return Optional.ofNullable((String)this.bindings.get(reference.name()));
    }

    private Optional<ExpressionFunction> functionInvocation(Reference reference) {
        if (reference.output() != null) {
            return Optional.empty();
        }
        ExpressionFunction function = (ExpressionFunction)this.functions().get(reference.name());
        if (function == null) {
            return Optional.empty();
        }
        if (function.arguments().size() != reference.arguments().size()) {
            return Optional.empty();
        }
        return Optional.of(function);
    }

    private Optional<TensorType> tensorFeatureType(Reference reference) {
        String dimension;
        if (!reference.name().equals("tensorFromLabels") && !reference.name().equals("tensorFromWeightedSet")) {
            return Optional.empty();
        }
        if (reference.arguments().size() != 1 && reference.arguments().size() != 2) {
            throw new IllegalArgumentException(reference.name() + " must have one or two arguments");
        }
        ExpressionNode arg0 = (ExpressionNode)reference.arguments().expressions().get(0);
        if (!(arg0 instanceof ReferenceNode) || !FeatureNames.isSimpleFeature(((ReferenceNode)arg0).reference())) {
            throw new IllegalArgumentException("The first argument of " + reference.name() + " must be a simple feature, not " + arg0);
        }
        if (reference.arguments().size() > 1) {
            ExpressionNode arg1 = (ExpressionNode)reference.arguments().expressions().get(1);
            if (!(arg1 instanceof ReferenceNode && ((ReferenceNode)arg1).reference().isIdentifier() || arg1 instanceof NameNode)) {
                throw new IllegalArgumentException("The second argument of " + reference.name() + " must be a dimension name, not " + arg1);
            }
            dimension = ((ExpressionNode)reference.arguments().expressions().get(1)).toString();
        } else {
            dimension = ((ExpressionNode)((ReferenceNode)arg0).reference().arguments().expressions().get(0)).toString();
        }
        return Optional.of(new TensorType.Builder().mapped(dimension).build());
    }

    private Map<String, String> bind(List<String> formalArguments, Arguments invocationArguments) {
        HashMap<String, String> bindings = new HashMap<String, String>(formalArguments.size());
        for (int i = 0; i < formalArguments.size(); ++i) {
            String identifier = ((ExpressionNode)invocationArguments.expressions().get(i)).toString();
            identifier = this.bindings.getOrDefault(identifier, identifier);
            bindings.put(formalArguments.get(i), identifier);
        }
        return bindings;
    }

    public Map<Reference, TensorType> featureTypes() {
        return Collections.unmodifiableMap(this.featureTypes);
    }

    public MapEvaluationTypeContext withBindings(Map<String, String> bindings) {
        if (bindings.isEmpty() && this.bindings.isEmpty()) {
            return this;
        }
        return new MapEvaluationTypeContext(this.functions(), bindings, this.featureTypes, this.currentResolutionCallStack);
    }
}

