/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.model.builder.UserConfigBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomSearchTuningBuilder;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.TopologicalDocumentTypeSorter;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.cluster.DomResourceLimitsBuilder;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.NamedSchema;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SchemaDefinitionXMLHandler;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.StreamingSearchCluster;
import com.yahoo.vespa.model.search.TransactionLogServer;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ContentSearchCluster
extends AbstractConfigProducer
implements ProtonConfig.Producer,
DispatchConfig.Producer {
    private final boolean flushOnShutdown;
    private final Map<String, AbstractSearchCluster> clusters = new TreeMap<String, AbstractSearchCluster>();
    private IndexedSearchCluster indexedCluster;
    private Redundancy redundancy;
    private final String clusterName;
    private final Map<String, NewDocumentType> documentDefinitions;
    private final Set<NewDocumentType> globallyDistributedDocuments;
    private Double visibilityDelay = 0.0;
    private final List<SearchNode> nonIndexed = new ArrayList<SearchNode>();
    private final Map<StorageGroup, NodeSpec> groupToSpecMap = new LinkedHashMap<StorageGroup, NodeSpec>();
    private Optional<ResourceLimits> resourceLimits = Optional.empty();
    private final ProtonConfig.Indexing.Optimize.Enum feedSequencerType;
    private final boolean combined;
    private Tuning tuning;

    public void prepare() {
        this.clusters.values().forEach(cluster -> cluster.prepareToDistributeFiles(this.getSearchNodes()));
    }

    private static ProtonConfig.Indexing.Optimize.Enum convertFeedSequencerType(String sequencerType) {
        try {
            return ProtonConfig.Indexing.Optimize.Enum.valueOf((String)sequencerType);
        }
        catch (Throwable t) {
            return ProtonConfig.Indexing.Optimize.Enum.LATENCY;
        }
    }

    private ContentSearchCluster(AbstractConfigProducer parent, String clusterName, ModelContext.Properties featureFlags, Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, boolean flushOnShutdown, boolean combined) {
        super(parent, "search");
        this.clusterName = clusterName;
        this.documentDefinitions = documentDefinitions;
        this.globallyDistributedDocuments = globallyDistributedDocuments;
        this.flushOnShutdown = flushOnShutdown;
        this.combined = combined;
        this.feedSequencerType = ContentSearchCluster.convertFeedSequencerType(featureFlags.feedSequencerType());
    }

    public void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
        if (this.hasIndexedCluster()) {
            this.indexedCluster.setVisibilityDelay(delay);
        }
    }

    private void addSearchCluster(DeployState deployState, SearchCluster cluster, Double queryTimeout, List<ModelElement> documentDefs) {
        this.addSchemas(deployState, documentDefs, cluster);
        if (queryTimeout != null) {
            cluster.setQueryTimeout(queryTimeout);
        }
        cluster.defaultDocumentsConfig();
        cluster.deriveSchemas(deployState);
        this.addCluster(cluster);
    }

    private void addSchemas(DeployState deployState, List<ModelElement> searchDefs, AbstractSearchCluster sc) {
        for (ModelElement e : searchDefs) {
            SchemaDefinitionXMLHandler schemaDefinitionXMLHandler = new SchemaDefinitionXMLHandler(e);
            NamedSchema searchDefinition = schemaDefinitionXMLHandler.getResponsibleSearchDefinition(deployState.getSchemas());
            if (searchDefinition == null) {
                throw new RuntimeException("Search definition parsing error or file does not exist: '" + schemaDefinitionXMLHandler.getName() + "'");
            }
            sc.getLocalSDS().add(new AbstractSearchCluster.SchemaSpec(searchDefinition, UserConfigBuilder.build(e.getXml(), deployState, deployState.getDeployLogger())));
            sc.addDocumentNames(searchDefinition);
        }
    }

    private void addCluster(AbstractSearchCluster sc) {
        if (this.clusters.containsKey(sc.getClusterName())) {
            throw new IllegalArgumentException("I already have registered cluster '" + sc.getClusterName() + "'");
        }
        if (sc instanceof IndexedSearchCluster) {
            if (this.indexedCluster != null) {
                throw new IllegalArgumentException("I already have one indexed cluster named '" + this.indexedCluster.getClusterName());
            }
            this.indexedCluster = (IndexedSearchCluster)sc;
        }
        this.clusters.put(sc.getClusterName(), sc);
    }

    public List<SearchNode> getSearchNodes() {
        return this.hasIndexedCluster() ? this.getIndexed().getSearchNodes() : this.nonIndexed;
    }

    public void addSearchNode(DeployState deployState, ContentNode node, StorageGroup parentGroup, ModelElement element) {
        TransactionLogServer tls;
        SearchNode searchNode;
        AbstractConfigProducer parent = this.hasIndexedCluster() ? this.getIndexed() : this;
        NodeSpec spec = this.getNextSearchNodeSpec(parentGroup);
        Optional<Tuning> tuning = Optional.ofNullable(this.tuning);
        if (element == null) {
            searchNode = SearchNode.create(deployState.getProperties(), parent, "" + node.getDistributionKey(), node.getDistributionKey(), spec, this.clusterName, node, this.flushOnShutdown, tuning, this.resourceLimits, parentGroup.isHosted(), this.combined);
            searchNode.setHostResource(node.getHostResource());
            searchNode.initService(deployState.getDeployLogger());
            tls = new TransactionLogServer(searchNode, this.clusterName);
            tls.setHostResource(searchNode.getHostResource());
            tls.initService(deployState.getDeployLogger());
        } else {
            searchNode = (SearchNode)new SearchNode.Builder("" + node.getDistributionKey(), spec, this.clusterName, node, this.flushOnShutdown, tuning, this.resourceLimits, this.combined).build(deployState, parent, element.getXml());
            tls = (TransactionLogServer)new TransactionLogServer.Builder(this.clusterName).build(deployState, searchNode, element.getXml());
        }
        searchNode.setTls(tls);
        if (this.hasIndexedCluster()) {
            this.getIndexed().addSearcher(searchNode);
        } else {
            this.nonIndexed.add(searchNode);
        }
    }

    private NodeSpec getNextSearchNodeSpec(StorageGroup parentGroup) {
        NodeSpec spec = this.groupToSpecMap.get(parentGroup);
        spec = spec == null ? new NodeSpec(this.groupToSpecMap.size(), 0) : new NodeSpec(spec.groupIndex(), spec.partitionId() + 1);
        this.groupToSpecMap.put(parentGroup, spec);
        return spec;
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    private void setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = Optional.of(resourceLimits);
    }

    public boolean usesHierarchicDistribution() {
        return this.indexedCluster != null && this.groupToSpecMap.size() > 1;
    }

    public void handleRedundancy(Redundancy redundancy) {
        if (this.hasIndexedCluster()) {
            if (this.usesHierarchicDistribution()) {
                this.indexedCluster.setMaxNodesDownPerFixedRow(redundancy.effectiveFinalRedundancy() / this.groupToSpecMap.size() - 1);
            }
            this.indexedCluster.setSearchableCopies(redundancy.readyCopies());
        }
        this.redundancy = redundancy;
        for (SearchNode node : this.getSearchNodes()) {
            node.setRedundancy(redundancy.finalRedundancy());
            node.setSearchableCopies(redundancy.readyCopies());
        }
    }

    private Optional<StreamingSearchCluster> findStreamingCluster(String docType) {
        return this.getClusters().values().stream().filter(StreamingSearchCluster.class::isInstance).map(StreamingSearchCluster.class::cast).filter(ssc -> ssc.getSdConfig().getSearch().getName().equals(docType)).findFirst();
    }

    public List<StreamingSearchCluster> getStreamingClusters() {
        return this.getClusters().values().stream().filter(StreamingSearchCluster.class::isInstance).map(StreamingSearchCluster.class::cast).collect(Collectors.toList());
    }

    public List<NewDocumentType> getDocumentTypesWithStreamingCluster() {
        return this.documentTypes(this::hasIndexingModeStreaming);
    }

    public List<NewDocumentType> getDocumentTypesWithIndexedCluster() {
        return this.documentTypes(this::hasIndexingModeIndexed);
    }

    public List<NewDocumentType> getDocumentTypesWithStoreOnly() {
        return this.documentTypes(this::hasIndexingModeStoreOnly);
    }

    private List<NewDocumentType> documentTypes(Predicate<NewDocumentType> filter) {
        return this.documentDefinitions.values().stream().filter(filter).collect(Collectors.toList());
    }

    private boolean hasIndexingModeStreaming(NewDocumentType type) {
        return this.findStreamingCluster(type.getFullName().getName()).isPresent();
    }

    private boolean hasIndexingModeIndexed(NewDocumentType type) {
        return !this.hasIndexingModeStreaming(type) && this.hasIndexedCluster() && this.getIndexed().hasDocumentDB(type.getFullName().getName());
    }

    private boolean hasIndexingModeStoreOnly(NewDocumentType type) {
        return !this.hasIndexingModeStreaming(type) && !this.hasIndexingModeIndexed(type);
    }

    public void getConfig(ProtonConfig.Builder builder) {
        builder.feeding.concurrency(0.5);
        boolean hasAnyNonIndexedCluster = false;
        for (NewDocumentType type : TopologicalDocumentTypeSorter.sort(this.documentDefinitions.values())) {
            ProtonConfig.Documentdb.Builder ddbB = new ProtonConfig.Documentdb.Builder();
            String docTypeName = type.getFullName().getName();
            boolean globalDocType = this.isGloballyDistributed(type);
            ddbB.inputdoctypename(docTypeName).configid(this.getConfigId()).visibilitydelay(this.visibilityDelay.doubleValue()).global(globalDocType);
            if (this.hasIndexingModeStreaming(type)) {
                hasAnyNonIndexedCluster = true;
                ddbB.inputdoctypename((String)type.getFullName().getName()).configid((String)this.findStreamingCluster((String)docTypeName).get().getDocumentDBConfigId()).mode((ProtonConfig.Documentdb.Mode.Enum)ProtonConfig.Documentdb.Mode.Enum.STREAMING).feeding.concurrency(0.0);
            } else if (this.hasIndexingModeIndexed(type)) {
                this.getIndexed().fillDocumentDBConfig(type.getFullName().getName(), ddbB);
                if (this.tuning != null && this.tuning.searchNode != null && this.tuning.searchNode.feeding != null) {
                    ddbB.feeding.concurrency(this.tuning.searchNode.feeding.concurrency / 2.0);
                } else {
                    ddbB.feeding.concurrency(builder.feeding.build().concurrency());
                }
            } else {
                hasAnyNonIndexedCluster = true;
                ddbB.feeding.concurrency(0.0);
                ddbB.mode(ProtonConfig.Documentdb.Mode.Enum.STORE_ONLY);
            }
            if (globalDocType) {
                ddbB.visibilitydelay(0.0);
            }
            builder.documentdb(ddbB);
        }
        int numDocumentDbs = builder.documentdb.size();
        builder.initialize(new ProtonConfig.Initialize.Builder().threads(numDocumentDbs + 1));
        this.resourceLimits.ifPresent(limits -> limits.getConfig(builder));
        if (this.tuning != null) {
            this.tuning.getConfig(builder);
        }
        if (this.redundancy != null) {
            this.redundancy.getConfig(builder);
        }
        if (hasAnyNonIndexedCluster) {
            builder.feeding.concurrency(builder.feeding.build().concurrency() * 2.0);
        }
        if (this.feedSequencerType == ProtonConfig.Indexing.Optimize.Enum.THROUGHPUT && this.visibilityDelay == 0.0) {
            builder.indexing.optimize(ProtonConfig.Indexing.Optimize.Enum.LATENCY);
        } else {
            builder.indexing.optimize(this.feedSequencerType);
        }
    }

    private boolean isGloballyDistributed(NewDocumentType docType) {
        return this.globallyDistributedDocuments.contains(docType);
    }

    public void getConfig(DispatchConfig.Builder builder) {
        if (this.hasIndexedCluster()) {
            this.getIndexed().getConfig(builder);
        }
    }

    public Map<String, AbstractSearchCluster> getClusters() {
        return this.clusters;
    }

    public IndexedSearchCluster getIndexed() {
        return this.indexedCluster;
    }

    public boolean hasIndexedCluster() {
        return this.indexedCluster != null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<ContentSearchCluster> {
        private final Map<String, NewDocumentType> documentDefinitions;
        private final Set<NewDocumentType> globallyDistributedDocuments;
        private final boolean combined;

        public Builder(Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, boolean combined) {
            this.documentDefinitions = documentDefinitions;
            this.globallyDistributedDocuments = globallyDistributedDocuments;
            this.combined = combined;
        }

        @Override
        protected ContentSearchCluster doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element producerSpec) {
            ModelElement protonElem;
            ModelElement clusterElem = new ModelElement(producerSpec);
            String clusterName = ContentCluster.getClusterId(clusterElem);
            Boolean flushOnShutdownElem = clusterElem.childAsBoolean("engine.proton.flush-on-shutdown");
            ContentSearchCluster search = new ContentSearchCluster(ancestor, clusterName, deployState.getProperties(), this.documentDefinitions, this.globallyDistributedDocuments, this.getFlushOnShutdown(flushOnShutdownElem, deployState), this.combined);
            ModelElement tuning = clusterElem.childByPath("engine.proton.tuning");
            if (tuning != null) {
                search.setTuning((Tuning)new DomSearchTuningBuilder().build(deployState, search, tuning.getXml()));
            }
            if ((protonElem = clusterElem.childByPath("engine.proton")) != null) {
                search.setResourceLimits(DomResourceLimitsBuilder.build(protonElem));
            }
            this.buildAllStreamingSearchClusters(deployState, clusterElem, clusterName, search);
            this.buildIndexedSearchCluster(deployState, clusterElem, clusterName, search);
            return search;
        }

        private boolean getFlushOnShutdown(Boolean flushOnShutdownElem, DeployState deployState) {
            if (flushOnShutdownElem != null) {
                return flushOnShutdownElem;
            }
            return !ContentSearchCluster.stateIsHosted(deployState);
        }

        private Double getQueryTimeout(ModelElement clusterElem) {
            return clusterElem.childAsDouble("engine.proton.query-timeout");
        }

        private void buildAllStreamingSearchClusters(DeployState deployState, ModelElement clusterElem, String clusterName, ContentSearchCluster search) {
            ModelElement docElem = clusterElem.child("documents");
            if (docElem == null) {
                return;
            }
            for (ModelElement docType : docElem.subElements("document")) {
                String mode = docType.stringAttribute("mode");
                if (!"streaming".equals(mode)) continue;
                this.buildStreamingSearchCluster(deployState, clusterElem, clusterName, search, docType);
            }
        }

        private void buildStreamingSearchCluster(DeployState deployState, ModelElement clusterElem, String clusterName, ContentSearchCluster search, ModelElement docType) {
            String docTypeName = docType.stringAttribute("type");
            StreamingSearchCluster cluster = new StreamingSearchCluster(search, clusterName + "." + docTypeName, 0, docTypeName, clusterName);
            search.addSearchCluster(deployState, cluster, this.getQueryTimeout(clusterElem), Arrays.asList(docType));
        }

        private void buildIndexedSearchCluster(DeployState deployState, ModelElement clusterElem, String clusterName, ContentSearchCluster search) {
            List<ModelElement> indexedDefs = this.getIndexedSchemas(clusterElem);
            if (!indexedDefs.isEmpty()) {
                IndexedSearchCluster isc = new IndexedSearchCluster(search, clusterName, 0, deployState);
                isc.setRoutingSelector(clusterElem.childAsString("documents.selection"));
                Double visibilityDelay = clusterElem.childAsDouble("engine.proton.visibility-delay");
                if (visibilityDelay != null) {
                    search.setVisibilityDelay(visibilityDelay);
                }
                search.addSearchCluster(deployState, isc, this.getQueryTimeout(clusterElem), indexedDefs);
            }
        }

        private List<ModelElement> getIndexedSchemas(ModelElement clusterElem) {
            ArrayList<ModelElement> indexedDefs = new ArrayList<ModelElement>();
            ModelElement docElem = clusterElem.child("documents");
            if (docElem == null) {
                return indexedDefs;
            }
            for (ModelElement docType : docElem.subElements("document")) {
                String mode = docType.stringAttribute("mode");
                if (!"index".equals(mode)) continue;
                indexedDefs.add(docType);
            }
            return indexedDefs;
        }
    }
}

