/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import java.util.List;

class SearchHandler
extends ProcessingHandler<SearchChains> {
    static final String HANDLER_CLASS = com.yahoo.search.handler.SearchHandler.class.getName();
    static final BindingPattern DEFAULT_BINDING = SystemBindingPattern.fromHttpPath("/search/*");
    private final ApplicationContainerCluster cluster;

    SearchHandler(ApplicationContainerCluster cluster, List<BindingPattern> bindings, ContainerThreadpool.UserOptions threadpoolOptions, DeployState deployState) {
        super(cluster.getSearchChains(), HANDLER_CLASS);
        this.cluster = cluster;
        bindings.forEach(xva$0 -> this.addServerBindings((BindingPattern)xva$0));
        Threadpool threadpool = new Threadpool(cluster, threadpoolOptions, deployState);
        this.inject(threadpool);
        this.addComponent(threadpool);
    }

    private static class Threadpool
    extends ContainerThreadpool {
        private final ApplicationContainerCluster cluster;
        private final DeployState deployState;

        Threadpool(ApplicationContainerCluster cluster, ContainerThreadpool.UserOptions options, DeployState deployState) {
            super("search-handler", options);
            this.cluster = cluster;
            this.deployState = deployState;
        }

        @Override
        public void getConfig(ContainerThreadpoolConfig.Builder builder) {
            super.getConfig(builder);
            builder.maxThreadExecutionTimeSeconds(190);
            builder.keepAliveTime(5.0);
            if (this.hasUserOptions()) {
                return;
            }
            double threadPoolSizeFactor = this.deployState.getProperties().threadPoolSizeFactor();
            double vcpu = this.cluster.vcpu().orElse(0.0);
            if (threadPoolSizeFactor <= 0.0 || vcpu == 0.0) {
                builder.maxThreads(500);
                builder.minThreads(500);
                builder.queueSize(0);
            } else {
                int workerThreads = Math.max(8, (int)Math.ceil(vcpu * threadPoolSizeFactor));
                builder.maxThreads(workerThreads);
                builder.minThreads(workerThreads);
                builder.queueSize((int)((double)workerThreads * this.deployState.getProperties().queueSizeFactor()));
            }
        }
    }
}

