/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.ThreadPoolProvider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;

class DefaultThreadpoolProvider
extends SimpleComponent
implements ThreadpoolConfig.Producer {
    private final ContainerCluster<?> cluster;
    private final DeployState deployState;

    DefaultThreadpoolProvider(ContainerCluster<?> cluster, DeployState deployState) {
        super(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)"default-threadpool", (String)ThreadPoolProvider.class.getName(), null)));
        this.cluster = cluster;
        this.deployState = deployState;
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        if (!(this.cluster instanceof ApplicationContainerCluster)) {
            int defaultWorkerThreads = 10;
            builder.maxthreads(defaultWorkerThreads);
            builder.corePoolSize(defaultWorkerThreads);
            builder.queueSize(50);
            return;
        }
        double threadPoolSizeFactor = this.deployState.getProperties().threadPoolSizeFactor();
        double vcpu = this.cluster.vcpu().orElse(0.0);
        if (threadPoolSizeFactor <= 0.0 || vcpu == 0.0) {
            return;
        }
        int workerThreads = Math.max(8, (int)Math.ceil(vcpu * threadPoolSizeFactor));
        builder.maxthreads(workerThreads);
        builder.corePoolSize(workerThreads);
        builder.queueSize((int)((double)workerThreads * this.deployState.getProperties().queueSizeFactor()));
    }
}

