/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.path.Path;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.expressiontransforms.OnnxModelTransformer;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import onnx.Onnx;

public class OnnxModelTypeResolver
extends Processor {
    public OnnxModelTypeResolver(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        for (Map.Entry<String, OnnxModel> entry : this.search.onnxModels().asMap().entrySet()) {
            OnnxModel modelConfig = entry.getValue();
            try {
                InputStream inputStream = this.openModelFile(modelConfig.getFilePath());
                try {
                    Onnx.ModelProto model = Onnx.ModelProto.parseFrom(inputStream);
                    for (Onnx.ValueInfoProto valueInfo : model.getGraph().getInputList()) {
                        String onnxInputName = valueInfo.getName();
                        String vespaInputName = OnnxModelTransformer.asValidIdentifier(onnxInputName);
                        modelConfig.addInputNameMapping(onnxInputName, vespaInputName, false);
                        modelConfig.addInputType(onnxInputName, valueInfo.getType());
                    }
                    for (Onnx.ValueInfoProto valueInfo : model.getGraph().getOutputList()) {
                        String onnxOutputName = valueInfo.getName();
                        String vespaOutputName = OnnxModelTransformer.asValidIdentifier(onnxOutputName);
                        modelConfig.addOutputNameMapping(onnxOutputName, vespaOutputName, false);
                        modelConfig.addOutputType(onnxOutputName, valueInfo.getType());
                    }
                    if (model.getGraph().getOutputList().isEmpty()) continue;
                    modelConfig.setDefaultOutput(model.getGraph().getOutput(0).getName());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse ONNX model", e);
            }
        }
    }

    static boolean modelFileExists(String path, ApplicationPackage app) {
        Path pathInApplicationPackage = Path.fromString((String)path);
        if (OnnxModelTypeResolver.getFile(pathInApplicationPackage, app).exists()) {
            return true;
        }
        return OnnxModelTypeResolver.getFileReference(pathInApplicationPackage, app).isPresent();
    }

    private InputStream openModelFile(Path path) throws FileNotFoundException {
        Path modelsPath = ApplicationPackage.MODELS_DIR.append(path);
        ApplicationFile file = this.getFile(path);
        if (file.exists()) {
            return file.createInputStream();
        }
        file = this.getFile(modelsPath);
        if (file.exists()) {
            return file.createInputStream();
        }
        Optional<FileReference> reference = this.getFileReference(path);
        if (reference.isPresent()) {
            return OnnxModelTypeResolver.openFromFileRepository(path, reference.get());
        }
        reference = this.getFileReference(modelsPath);
        if (reference.isPresent()) {
            return OnnxModelTypeResolver.openFromFileRepository(modelsPath, reference.get());
        }
        throw new IllegalArgumentException("Unable to find ONNX model file \"" + path + "\" in application package or file repository.");
    }

    private ApplicationFile getFile(Path path) {
        return OnnxModelTypeResolver.getFile(path, this.search.applicationPackage());
    }

    private static ApplicationFile getFile(Path path, ApplicationPackage app) {
        return app.getFile(path);
    }

    private static InputStream openFromFileRepository(Path path, FileReference reference) throws FileNotFoundException {
        return new FileInputStream(new File(OnnxModelTypeResolver.getFileRepositoryPath(path, reference.value())));
    }

    public static String getFileRepositoryPath(Path path, String fileReference) {
        ConfigserverConfig cfg = new ConfigserverConfig(new ConfigserverConfig.Builder());
        String fileRefDir = Defaults.getDefaults().underVespaHome(cfg.fileReferencesDir());
        return Paths.get(fileRefDir, fileReference, path.getName()).toString();
    }

    private Optional<FileReference> getFileReference(Path path) {
        return OnnxModelTypeResolver.getFileReference(path, this.search.applicationPackage());
    }

    private static Optional<FileReference> getFileReference(Path path, ApplicationPackage app) {
        Optional<FileRegistry> fileRegistry = OnnxModelTypeResolver.getLatestFileRegistry(app);
        if (fileRegistry.isPresent()) {
            for (FileRegistry.Entry file : fileRegistry.get().export()) {
                if (!file.relativePath.equals(path.toString())) continue;
                return Optional.of(file.reference);
            }
        }
        return Optional.empty();
    }

    private static Optional<FileRegistry> getLatestFileRegistry(ApplicationPackage app) {
        if (app == null) {
            return Optional.empty();
        }
        Optional latest = app.getFileRegistries().keySet().stream().max(Version::compareTo);
        return latest.isEmpty() ? Optional.empty() : Optional.of((FileRegistry)app.getFileRegistries().get(latest.get()));
    }
}

